/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.Logging;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseModalLayout
extends FrameLayout {
    private static final float DEFAULT_MAX_WIDTH_PCT = -1.0f;
    private static final float DEFAULT_MAX_HEIGHT_PCT = -1.0f;
    private float mMaxWidthPct;
    private float mMaxHeightPct;
    private DisplayMetrics mDisplay;
    private List<View> mVisibleChildren = new ArrayList<View>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseModalLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ModalLayout, 0, 0);
        try {
            this.mMaxWidthPct = a.getFloat(R.styleable.ModalLayout_maxWidthPct, -1.0f);
            this.mMaxHeightPct = a.getFloat(R.styleable.ModalLayout_maxHeightPct, -1.0f);
        }
        finally {
            a.recycle();
        }
        this.mDisplay = context.getResources().getDisplayMetrics();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Logging.logdHeader("BEGIN LAYOUT");
        Logging.logd("onLayout: l: " + left + ", t: " + top + ", r: " + right + ", b: " + bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Logging.logdHeader("BEGIN MEASURE");
        Logging.logdPair("Display", this.getDisplayMetrics().widthPixels, this.getDisplayMetrics().heightPixels);
        this.mVisibleChildren.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 8) {
                this.mVisibleChildren.add(child);
                continue;
            }
            Logging.logdNumber("Skipping GONE child", i);
        }
    }

    protected float getMaxWidthPct() {
        return this.mMaxWidthPct;
    }

    protected float getMaxHeightPct() {
        return this.mMaxHeightPct;
    }

    protected DisplayMetrics getDisplayMetrics() {
        return this.mDisplay;
    }

    protected List<View> getVisibleChildren() {
        return this.mVisibleChildren;
    }

    protected int calculateBaseWidth(int widthMeasureSpec) {
        int baseLayoutWidth;
        if (this.getMaxWidthPct() > 0.0f) {
            Logging.logd("Width: restrict by pct");
            baseLayoutWidth = this.roundToNearest((int)((float)this.getDisplayMetrics().widthPixels * this.getMaxWidthPct()), 4);
        } else {
            Logging.logd("Width: restrict by spec");
            baseLayoutWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        return baseLayoutWidth;
    }

    protected int calculateBaseHeight(int heightMeasureSpec) {
        int baseLayoutHeight;
        if (this.getMaxHeightPct() > 0.0f) {
            Logging.logd("Height: restrict by pct");
            baseLayoutHeight = this.roundToNearest((int)((float)this.getDisplayMetrics().heightPixels * this.getMaxHeightPct()), 4);
        } else {
            Logging.logd("Height: restrict by spec");
            baseLayoutHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        return baseLayoutHeight;
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        Logging.logdPair("\tdesired (w,h)", child.getMeasuredWidth(), child.getMeasuredHeight());
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        Logging.logdPair("\tactual  (w,h)", child.getMeasuredWidth(), child.getMeasuredHeight());
    }

    protected void layoutChild(View view, int left, int top) {
        this.layoutChild(view, left, top, left + this.getDesiredWidth(view), top + this.getDesiredHeight(view));
    }

    protected void layoutChild(View view, int left, int top, int right, int bottom) {
        Logging.logdPair("\tleft, right", left, right);
        Logging.logdPair("\ttop, bottom", top, bottom);
        view.layout(left, top, right, bottom);
    }

    @NonNull
    protected View findChildById(@IdRes int id2) {
        View v = this.findViewById(id2);
        if (v == null) {
            throw new IllegalStateException("No such child: " + id2);
        }
        return v;
    }

    protected int getHeightWithMargins(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        FrameLayout.LayoutParams params = this.getLayoutParams(child);
        return this.getDesiredHeight(child) + params.topMargin + params.bottomMargin;
    }

    protected int getMarginBottom(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        return this.getLayoutParams((View)child).bottomMargin;
    }

    protected int getMarginTop(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        return this.getLayoutParams((View)child).topMargin;
    }

    protected int getWidthWithMargins(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        FrameLayout.LayoutParams params = this.getLayoutParams(child);
        return this.getDesiredWidth(child) + params.leftMargin + params.rightMargin;
    }

    protected int getDesiredWidth(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        return child.getMeasuredWidth();
    }

    protected int getDesiredHeight(View child) {
        if (child.getVisibility() == 8) {
            return 0;
        }
        return child.getMeasuredHeight();
    }

    protected FrameLayout.LayoutParams getLayoutParams(View child) {
        return (FrameLayout.LayoutParams)child.getLayoutParams();
    }

    protected int roundToNearest(int num, int unit) {
        return unit * Math.round((float)num / (float)unit);
    }

    protected int dpToPixels(int dp) {
        return (int)Math.floor(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mDisplay));
    }
}

