/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.injection.modules;

import android.app.Application;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.google.firebase.inappmessaging.display.dagger.Module;
import com.google.firebase.inappmessaging.display.dagger.Provides;
import com.google.firebase.inappmessaging.display.dagger.multibindings.IntoMap;
import com.google.firebase.inappmessaging.display.dagger.multibindings.StringKey;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.model.MessageType;

@Module
public class InflaterConfigModule {
    public static int DISABLED_BG_FLAG = 327938;
    public static int DISMISSIBLE_DIALOG_FLAG = 327970;
    private int ENABLED_BG_FLAG = 65824;

    public static String configFor(MessageType type, int orientation) {
        if (orientation == 1) {
            switch (type) {
                case MODAL: {
                    return "MODAL_PORTRAIT";
                }
                case CARD: {
                    return "CARD_PORTRAIT";
                }
                case IMAGE_ONLY: {
                    return "IMAGE_ONLY_PORTRAIT";
                }
                case BANNER: {
                    return "BANNER_PORTRAIT";
                }
            }
            return null;
        }
        switch (type) {
            case MODAL: {
                return "MODAL_LANDSCAPE";
            }
            case CARD: {
                return "CARD_LANDSCAPE";
            }
            case IMAGE_ONLY: {
                return "IMAGE_ONLY_LANDSCAPE";
            }
            case BANNER: {
                return "BANNER_LANDSCAPE";
            }
        }
        return null;
    }

    @Provides
    DisplayMetrics providesDisplayMetrics(Application application) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)application.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    @Provides
    @IntoMap
    @StringKey(value="IMAGE_ONLY_PORTRAIT")
    public InAppMessageLayoutConfig providesPortraitImageLayoutConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.9f * (float)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.9f * (float)displayMetrics.widthPixels)).setMaxImageWidthWeight(Float.valueOf(0.8f)).setMaxImageHeightWeight(Float.valueOf(0.8f)).setViewWindowGravity(17).setWindowFlag(DISABLED_BG_FLAG).setWindowWidth(-2).setWindowHeight(-2).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="IMAGE_ONLY_LANDSCAPE")
    public InAppMessageLayoutConfig providesLandscapeImageLayoutConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.9f * (float)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.9f * (float)displayMetrics.widthPixels)).setMaxImageWidthWeight(Float.valueOf(0.8f)).setMaxImageHeightWeight(Float.valueOf(0.8f)).setViewWindowGravity(17).setWindowFlag(DISABLED_BG_FLAG).setWindowWidth(-2).setWindowHeight(-2).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="MODAL_LANDSCAPE")
    public InAppMessageLayoutConfig providesModalLandscapeConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.8 * (double)displayMetrics.heightPixels)).setMaxDialogWidthPx(displayMetrics.widthPixels).setMaxImageHeightWeight(Float.valueOf(1.0f)).setMaxImageWidthWeight(Float.valueOf(0.4f)).setMaxBodyHeightWeight(Float.valueOf(0.6f)).setMaxBodyWidthWeight(Float.valueOf(0.4f)).setViewWindowGravity(17).setWindowFlag(DISABLED_BG_FLAG).setWindowWidth(-1).setWindowHeight(-1).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="MODAL_PORTRAIT")
    public InAppMessageLayoutConfig providesModalPortraitConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.8 * (double)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.7f * (float)displayMetrics.widthPixels)).setMaxImageHeightWeight(Float.valueOf(0.6f)).setMaxBodyHeightWeight(Float.valueOf(0.1f)).setMaxImageWidthWeight(Float.valueOf(0.9f)).setMaxBodyWidthWeight(Float.valueOf(0.9f)).setViewWindowGravity(17).setWindowFlag(DISABLED_BG_FLAG).setWindowWidth(-1).setWindowHeight(-2).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="CARD_LANDSCAPE")
    public InAppMessageLayoutConfig providesCardLandscapeConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.8 * (double)displayMetrics.heightPixels)).setMaxDialogWidthPx(displayMetrics.widthPixels).setMaxImageHeightWeight(Float.valueOf(1.0f)).setMaxImageWidthWeight(Float.valueOf(0.5f)).setViewWindowGravity(17).setWindowFlag(DISMISSIBLE_DIALOG_FLAG).setWindowWidth(-2).setWindowHeight(-2).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="CARD_PORTRAIT")
    public InAppMessageLayoutConfig providesCardPortraitConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxDialogHeightPx((int)(0.8 * (double)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.7f * (float)displayMetrics.widthPixels)).setMaxImageHeightWeight(Float.valueOf(0.6f)).setMaxImageWidthWeight(Float.valueOf(1.0f)).setMaxBodyHeightWeight(Float.valueOf(0.1f)).setMaxBodyWidthWeight(Float.valueOf(0.9f)).setViewWindowGravity(17).setWindowFlag(DISMISSIBLE_DIALOG_FLAG).setWindowWidth(-2).setWindowHeight(-2).setBackgroundEnabled(false).setAnimate(false).setAutoDismiss(false).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="BANNER_PORTRAIT")
    public InAppMessageLayoutConfig providesBannerPortraitLayoutConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxImageHeightWeight(Float.valueOf(0.3f)).setMaxImageWidthWeight(Float.valueOf(0.3f)).setMaxDialogHeightPx((int)(0.5f * (float)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.9f * (float)displayMetrics.widthPixels)).setViewWindowGravity(48).setWindowFlag(this.ENABLED_BG_FLAG).setWindowWidth(-1).setWindowHeight(-2).setBackgroundEnabled(true).setAnimate(true).setAutoDismiss(true).build();
    }

    @Provides
    @IntoMap
    @StringKey(value="BANNER_LANDSCAPE")
    public InAppMessageLayoutConfig providesBannerLandscapeLayoutConfig(DisplayMetrics displayMetrics) {
        return InAppMessageLayoutConfig.builder().setMaxImageHeightWeight(Float.valueOf(0.3f)).setMaxImageWidthWeight(Float.valueOf(0.3f)).setMaxDialogHeightPx((int)(0.5f * (float)displayMetrics.heightPixels)).setMaxDialogWidthPx((int)(0.9f * (float)displayMetrics.widthPixels)).setViewWindowGravity(48).setWindowFlag(this.ENABLED_BG_FLAG).setWindowWidth(-1).setWindowHeight(-2).setBackgroundEnabled(true).setAnimate(true).setAutoDismiss(true).build();
    }
}

