/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.MessagesProto;

public class Text {
    @Nullable
    private final String text;
    @NonNull
    private final String hexColor;

    public int hashCode() {
        return this.text != null ? this.text.hashCode() + this.hexColor.hashCode() : this.hexColor.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text t = (Text)o;
        if (this.hashCode() != t.hashCode()) {
            return false;
        }
        if (this.text == null && t.text != null || this.text != null && !this.text.equals(t.text)) {
            return false;
        }
        return this.hexColor.equals(t.hexColor);
    }

    private Text(@Nullable String text, @NonNull String hexColor) {
        this.text = text;
        this.hexColor = hexColor;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @NonNull
    public String getHexColor() {
        return this.hexColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String text;
        @Nullable
        private String hexColor;

        public Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public Builder setText(MessagesProto.Text text) {
            this.setText(text.getText());
            this.setHexColor(text.getHexColor());
            return this;
        }

        public Builder setHexColor(@Nullable String hexColor) {
            this.hexColor = hexColor;
            return this;
        }

        public Text build() {
            if (TextUtils.isEmpty((CharSequence)this.hexColor)) {
                throw new IllegalArgumentException("Text model must have a color");
            }
            return new Text(this.text, this.hexColor);
        }
    }
}

