/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.internal.SharedPreferencesUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class DataCollectionHelper {
    @VisibleForTesting
    static final String MANIFEST_METADATA_AUTO_INIT_ENABLED = "firebase_inapp_messaging_auto_data_collection_enabled";
    @VisibleForTesting
    static final String AUTO_INIT_PREFERENCES = "auto_init";
    private SharedPreferencesUtils sharedPreferencesUtils;
    private AtomicBoolean isGlobalAutomaticDataCollectionEnabled;

    @Inject
    public DataCollectionHelper(FirebaseApp firebaseApp, SharedPreferencesUtils sharedPreferencesUtils, Subscriber firebaseEventsSubscriber) {
        this.sharedPreferencesUtils = sharedPreferencesUtils;
        this.isGlobalAutomaticDataCollectionEnabled = new AtomicBoolean(firebaseApp.isDataCollectionDefaultEnabled());
        firebaseEventsSubscriber.subscribe(DataCollectionDefaultChange.class, event -> {
            DataCollectionDefaultChange change = (DataCollectionDefaultChange)event.getPayload();
            this.isGlobalAutomaticDataCollectionEnabled.set(change.enabled);
        });
    }

    public boolean isAutomaticDataCollectionEnabled() {
        if (this.isProductManuallySet()) {
            return this.sharedPreferencesUtils.getBooleanPreference(AUTO_INIT_PREFERENCES, true);
        }
        if (this.isProductManifestSet()) {
            return this.sharedPreferencesUtils.getBooleanManifestValue(MANIFEST_METADATA_AUTO_INIT_ENABLED, true);
        }
        return this.isGlobalAutomaticDataCollectionEnabled.get();
    }

    public void setAutomaticDataCollectionEnabled(boolean isEnabled) {
        this.sharedPreferencesUtils.setBooleanPreference(AUTO_INIT_PREFERENCES, isEnabled);
    }

    public void setAutomaticDataCollectionEnabled(Boolean isEnabled) {
        if (isEnabled == null) {
            this.sharedPreferencesUtils.clearPreference(AUTO_INIT_PREFERENCES);
        } else {
            this.sharedPreferencesUtils.setBooleanPreference(AUTO_INIT_PREFERENCES, Boolean.TRUE.equals(isEnabled));
        }
    }

    private boolean readAutomaticDataCollectionEnabledFromPreferences() {
        return this.sharedPreferencesUtils.getBooleanPreference(AUTO_INIT_PREFERENCES, true);
    }

    private boolean isProductManuallySet() {
        return this.sharedPreferencesUtils.isPreferenceSet(AUTO_INIT_PREFERENCES);
    }

    private boolean isProductManifestSet() {
        return this.sharedPreferencesUtils.isManifestSet(MANIFEST_METADATA_AUTO_INIT_ENABLED);
    }
}

