/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.content.Context;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class CrossProcessLock {
    private final FileChannel channel;
    private final FileLock lock;

    private CrossProcessLock(FileChannel channel, FileLock lock) {
        this.channel = channel;
        this.lock = lock;
    }

    static CrossProcessLock acquire(Context appContext, String lockName) {
        try {
            File file = new File(appContext.getFilesDir(), lockName);
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            FileLock lock = channel.lock();
            return new CrossProcessLock(channel, lock);
        }
        catch (IOException e) {
            throw new IllegalStateException("exception while using file locks, should never happen", e);
        }
    }

    void releaseAndClose() {
        try {
            this.lock.release();
            this.channel.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("exception while using file locks, should never happen", e);
        }
    }
}

