/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zza;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zzd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private final AppMeasurement zzbqh;
    private static volatile AnalyticsConnector zzbqi;
    @VisibleForTesting
    final Map<String, zza> zzbqj;

    private AnalyticsConnectorImpl(AppMeasurement appMeasurement) {
        Preconditions.checkNotNull((Object)appMeasurement);
        this.zzbqh = appMeasurement;
        this.zzbqj = new ConcurrentHashMap<String, zza>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    public static AnalyticsConnector getInstance(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzbqi != null) return zzbqi;
        Class<AnalyticsConnector> clazz = AnalyticsConnector.class;
        synchronized (AnalyticsConnector.class) {
            if (zzbqi != null) return zzbqi;
            zzbqi = new AnalyticsConnectorImpl(AppMeasurement.getInstance((Context)context));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbqi;
        }
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!zzc.zzff(string)) {
            return;
        }
        if (!zzc.zza(string2, bundle)) {
            return;
        }
        if (!zzc.zzb(string, string2, bundle)) {
            return;
        }
        this.zzbqh.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, Object object) {
        if (!zzc.zzff(string)) {
            return;
        }
        if (!zzc.zzw(string, string2)) {
            return;
        }
        this.zzbqh.setUserPropertyInternal(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzbqh.getUserProperties(bl);
    }

    @WorkerThread
    @KeepForSdk
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @NonNull String string, AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!zzc.zzff(string)) {
            return null;
        }
        if (this.zzfe(string)) {
            return null;
        }
        AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener2 = analyticsConnectorListener;
        AppMeasurement appMeasurement = this.zzbqh;
        String string2 = string;
        zzd zzd2 = "fiam".equals(string2) ? new zzd(appMeasurement, analyticsConnectorListener2) : null;
        if (zzd2 != null) {
            this.zzbqj.put(string, zzd2);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){

                public void unregister() {
                    if (!AnalyticsConnectorImpl.this.zzfe(string)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zzbqj.get(string).zzss();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    AnalyticsConnectorImpl.this.zzbqj.remove(string);
                }

                @KeepForSdk
                public void registerEventNames(Set<String> set) {
                    if (!AnalyticsConnectorImpl.this.zzfe(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzbqj.get(string).registerEventNames(set);
                }

                @KeepForSdk
                public void unregisterEventNames() {
                    if (!AnalyticsConnectorImpl.this.zzfe(string) || !string.equals("fiam")) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzbqj.get(string).unregisterEventNames();
                }
            };
        }
        return null;
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!zzc.zza(conditionalUserProperty)) {
            return;
        }
        this.zzbqh.setConditionalUserProperty(zzc.zzb(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (string2 != null && !zzc.zza(string2, bundle)) {
            return;
        }
        this.zzbqh.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzbqh.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = zzc.zzd((AppMeasurement.ConditionalUserProperty)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzbqh.getMaxUserProperties(string);
    }

    private final boolean zzfe(@NonNull String string) {
        return !string.isEmpty() && this.zzbqj.containsKey(string) && this.zzbqj.get(string) != null;
    }
}

