/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zzd;
import com.google.firebase.analytics.connector.internal.zzf;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.analytics.connector.zzb;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzbta;
    @VisibleForTesting
    private final AppMeasurement zzbtb;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zzbtc;

    private AnalyticsConnectorImpl(AppMeasurement appMeasurement) {
        Preconditions.checkNotNull((Object)appMeasurement);
        this.zzbtb = appMeasurement;
        this.zzbtc = new ConcurrentHashMap<String, com.google.firebase.analytics.connector.internal.zza>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp, Context context, Subscriber subscriber) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzbta != null) return zzbta;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            if (zzbta != null) return zzbta;
            Bundle bundle = new Bundle(1);
            if (firebaseApp.isDefaultApp()) {
                subscriber.subscribe(DataCollectionDefaultChange.class, zza.zzbtd, zzb.zzbte);
                bundle.putBoolean("dataCollectionDefaultEnabled", firebaseApp.isDataCollectionDefaultEnabled());
            }
            zzal zzal2 = zzal.zzc((Bundle)bundle);
            zzbta = new AnalyticsConnectorImpl(zzbu.zza((Context)context, (zzal)zzal2).zzkm());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzbta;
        }
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!zzc.zzfv(string)) {
            return;
        }
        if (!zzc.zza(string2, bundle)) {
            return;
        }
        if (!zzc.zzb(string, string2, bundle)) {
            return;
        }
        this.zzbtb.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, Object object) {
        if (!zzc.zzfv(string)) {
            return;
        }
        if (!zzc.zzz(string, string2)) {
            return;
        }
        this.zzbtb.setUserPropertyInternal(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzbtb.getUserProperties(bl);
    }

    @WorkerThread
    @KeepForSdk
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @NonNull String string, AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        com.google.firebase.analytics.connector.internal.zza zza2;
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!zzc.zzfv(string)) {
            return null;
        }
        if (this.zzfu(string)) {
            return null;
        }
        AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener2 = analyticsConnectorListener;
        AppMeasurement appMeasurement = this.zzbtb;
        String string2 = string;
        if (("fiam".equals(string2) ? new zzd(appMeasurement, analyticsConnectorListener2) : (zza2 = "crash".equals(string2) ? new zzf(appMeasurement, analyticsConnectorListener2) : null)) != null) {
            this.zzbtc.put(string, zza2);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){

                public void unregister() {
                    if (!AnalyticsConnectorImpl.this.zzfu(string)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zzbtc.get(string).zztv();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    AnalyticsConnectorImpl.this.zzbtc.remove(string);
                }

                @KeepForSdk
                public void registerEventNames(Set<String> set) {
                    if (!AnalyticsConnectorImpl.this.zzfu(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzbtc.get(string).registerEventNames(set);
                }

                @KeepForSdk
                public void unregisterEventNames() {
                    if (!AnalyticsConnectorImpl.this.zzfu(string) || !string.equals("fiam")) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzbtc.get(string).unregisterEventNames();
                }
            };
        }
        return null;
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!zzc.zza(conditionalUserProperty)) {
            return;
        }
        this.zzbtb.setConditionalUserProperty(zzc.zzb(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (string2 != null && !zzc.zza(string2, bundle)) {
            return;
        }
        this.zzbtb.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzbtb.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = zzc.zzd((AppMeasurement.ConditionalUserProperty)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzbtb.getMaxUserProperties(string);
    }

    private final boolean zzfu(@NonNull String string) {
        return !string.isEmpty() && this.zzbtc.containsKey(string) && this.zzbtc.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            ((AnalyticsConnectorImpl)AnalyticsConnectorImpl.zzbta).zzbtb.zzd(bl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

