/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzq;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzd;
import java.util.Iterator;

public class FirebaseMessagingService
extends zzb {
    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string2) {
    }

    @WorkerThread
    public void onSendError(String string2, Exception exception) {
    }

    protected final Intent zzn(Intent intent) {
        return zzq.zzKm().zzKn();
    }

    public final boolean zzo(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            FirebaseMessagingService firebaseMessagingService = this;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (FirebaseMessagingService.zzJ(intent2.getExtras())) {
                zzd.zzh((Context)firebaseMessagingService, intent2);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleIntent(Intent intent) {
        String string2 = intent.getAction();
        if (string2 == null) {
            string2 = "";
        }
        switch (string2) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                Intent intent2 = intent;
                FirebaseMessagingService firebaseMessagingService = this;
                String string3 = intent2.getStringExtra("message_type");
                if (string3 == null) {
                    string3 = "gcm";
                }
                switch (string3) {
                    case "gcm": {
                        if (FirebaseMessagingService.zzJ(intent2.getExtras())) {
                            zzd.zzg((Context)firebaseMessagingService, intent2);
                        }
                        Intent intent3 = intent2;
                        FirebaseMessagingService firebaseMessagingService2 = firebaseMessagingService;
                        Bundle bundle = intent3.getExtras();
                        if (bundle == null) {
                            bundle = new Bundle();
                        }
                        bundle.remove("android.support.content.wakelockid");
                        if (zza.zzG(bundle)) {
                            if (zza.zzbM((Context)firebaseMessagingService2).zzv(bundle)) return;
                            if (FirebaseMessagingService.zzJ(bundle)) {
                                zzd.zzj((Context)firebaseMessagingService2, intent3);
                            }
                        }
                        firebaseMessagingService2.onMessageReceived(new RemoteMessage(bundle));
                        return;
                    }
                    case "deleted_messages": {
                        firebaseMessagingService.onDeletedMessages();
                        return;
                    }
                    case "send_event": {
                        firebaseMessagingService.onMessageSent(intent2.getStringExtra("google.message_id"));
                        return;
                    }
                    case "send_error": {
                        Intent intent4 = intent2;
                        String string4 = intent4.getStringExtra("google.message_id");
                        if (string4 == null) {
                            string4 = intent4.getStringExtra("message_id");
                        }
                        firebaseMessagingService.onSendError(string4, new SendException(intent2.getStringExtra("error")));
                        return;
                    }
                }
                String string5 = String.valueOf(string3);
                Log.w((String)"FirebaseMessaging", (String)(string5.length() != 0 ? "Received message with unknown type: ".concat(string5) : new String("Received message with unknown type: ")));
                return;
            }
            case "com.google.firebase.messaging.NOTIFICATION_DISMISS": {
                if (!FirebaseMessagingService.zzJ(intent.getExtras())) return;
                zzd.zzi((Context)this, intent);
                return;
            }
            default: {
                String string6 = String.valueOf(intent.getAction());
                Log.d((String)"FirebaseMessaging", (String)(string6.length() != 0 ? "Unknown intent action: ".concat(string6) : new String("Unknown intent action: ")));
            }
        }
    }

    static void zzt(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzJ(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

