/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle zza;
    private Map<String, String> zzb;
    private Notification zzc;

    RemoteMessage(Bundle bundle) {
        this.zza = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zza, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zza.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zza.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzb == null) {
            this.zzb = new ArrayMap();
            for (String string2 : this.zza.keySet()) {
                Object object = this.zza.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzb.put(string2, string3);
            }
        }
        return this.zzb;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zza.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zza.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zza.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zza.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zza.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zza.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzc == null && com.google.firebase.messaging.zza.zza(this.zza)) {
            this.zzc = new Notification(this.zza, null);
        }
        return this.zzc;
    }

    public static class Notification {
        private final String zza;
        private final String zzb;
        private final String[] zzc;
        private final String zzd;
        private final String zze;
        private final String[] zzf;
        private final String zzg;
        private final String zzh;
        private final String zzi;
        private final String zzj;
        private final String zzk;
        private final Uri zzl;

        private Notification(Bundle bundle) {
            this.zza = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.title");
            this.zzb = com.google.firebase.messaging.zza.zzb(bundle, "gcm.n.title");
            this.zzc = Notification.zza(bundle, "gcm.n.title");
            this.zzd = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.body");
            this.zze = com.google.firebase.messaging.zza.zzb(bundle, "gcm.n.body");
            this.zzf = Notification.zza(bundle, "gcm.n.body");
            this.zzg = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.icon");
            this.zzh = com.google.firebase.messaging.zza.zzd(bundle);
            this.zzi = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.tag");
            this.zzj = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.color");
            this.zzk = com.google.firebase.messaging.zza.zza(bundle, "gcm.n.click_action");
            this.zzl = com.google.firebase.messaging.zza.zzb(bundle);
        }

        private static String[] zza(Bundle bundle, String string2) {
            Object[] objectArray = com.google.firebase.messaging.zza.zzc(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zza;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzb;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzc;
        }

        @Nullable
        public String getBody() {
            return this.zzd;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zze;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzf;
        }

        @Nullable
        public String getIcon() {
            return this.zzg;
        }

        @Nullable
        public String getSound() {
            return this.zzh;
        }

        @Nullable
        public String getTag() {
            return this.zzi;
        }

        @Nullable
        public String getColor() {
            return this.zzj;
        }

        @Nullable
        public String getClickAction() {
            return this.zzk;
        }

        @Nullable
        public Uri getLink() {
            return this.zzl;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zza = new Bundle();
        private final Map<String, String> zzb = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zza.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzb.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zza);
            this.zza.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzb.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzb.clear();
            this.zzb.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzb.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zza.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zza.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zza.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zza.putString("collapse_key", string2);
            return this;
        }
    }
}

