/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.MessengerIpcClient;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.messaging.DisplayNotification;
import com.google.firebase.messaging.EnhancedIntentService;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingService$$Lambda$0;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseMessagingService
extends EnhancedIntentService {
    public static final String ACTION_DIRECT_BOOT_REMOTE_INTENT = "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT";
    private static final Queue<String> recentlyReceivedMessageIds = new ArrayDeque<String>(10);

    @WorkerThread
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(@NonNull String string) {
    }

    @WorkerThread
    public void onSendError(@NonNull String string, @NonNull Exception exception) {
    }

    @WorkerThread
    public void onNewToken(@NonNull String string) {
    }

    @Override
    protected Intent getStartCommandIntent(Intent intent) {
        return ServiceStarter.getInstance().getMessagingEvent();
    }

    @Override
    public boolean handleIntentOnMainThread(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.handleNotificationOpen(intent);
            return true;
        }
        return false;
    }

    private void handleNotificationOpen(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
            }
        }
        if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
            MessagingAnalytics.logNotificationOpen(intent);
        }
    }

    @Override
    public void handleIntent(Intent intent) {
        String string = intent.getAction();
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string) || ACTION_DIRECT_BOOT_REMOTE_INTENT.equals(string)) {
            this.handleMessageIntent(intent);
            return;
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(string)) {
            if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
                MessagingAnalytics.logNotificationDismiss(intent);
                return;
            }
        } else {
            if ("com.google.firebase.messaging.NEW_TOKEN".equals(string)) {
                this.onNewToken(intent.getStringExtra("token"));
                return;
            }
            String string2 = String.valueOf(intent.getAction());
            Log.d((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Unknown intent action: ".concat(string2) : new String("Unknown intent action: ")));
        }
    }

    private void handleMessageIntent(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        Task<Void> task = this.ackMessage(string);
        if (!this.alreadyReceivedMessage(string)) {
            this.passMessageIntentToSdk(intent);
        }
        try {
            Tasks.await(task, (long)this.getAckTimeoutMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string2 = String.valueOf(exception);
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Message ack failed: ").append(string2).toString());
            return;
        }
    }

    private void passMessageIntentToSdk(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
                    MessagingAnalytics.logNotificationReceived(intent, null);
                }
                if (MessagingAnalytics.shouldUploadFirelogAnalytics(intent)) {
                    TransportFactory transportFactory = FirebaseMessaging.getTransportFactory();
                    if (transportFactory != null) {
                        Transport transport = transportFactory.getTransport("FCM_CLIENT_EVENT_LOGGING", String.class, Encoding.of((String)"json"), FirebaseMessagingService$$Lambda$0.$instance);
                        MessagingAnalytics.logNotificationReceived(intent, (Transport<String>)transport);
                    } else {
                        Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
                    }
                }
                this.dispatchMessage(intent);
                return;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                return;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                return;
            }
            case "send_error": {
                this.onSendError(this.getMessageId(intent), new SendException(intent.getStringExtra("error")));
                return;
            }
        }
        String string2 = String.valueOf(string);
        Log.w((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Received message with unknown type: ".concat(string2) : new String("Received message with unknown type: ")));
    }

    private void dispatchMessage(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.remove("androidx.content.wakelockid");
        if (NotificationParams.isNotification(bundle)) {
            NotificationParams notificationParams = new NotificationParams(bundle);
            ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
            DisplayNotification displayNotification = new DisplayNotification((Context)this, notificationParams, executorService);
            try {
                if (displayNotification.handleNotification()) {
                    return;
                }
            }
            finally {
                executorService.shutdown();
            }
            if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
                MessagingAnalytics.logNotificationForeground(intent);
            }
        }
        this.onMessageReceived(new RemoteMessage(bundle));
    }

    private boolean alreadyReceivedMessage(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (recentlyReceivedMessageIds.contains(string)) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Received duplicate message: ".concat(string2) : new String("Received duplicate message: ")));
            }
            return true;
        }
        if (recentlyReceivedMessageIds.size() >= 10) {
            recentlyReceivedMessageIds.remove();
        }
        recentlyReceivedMessageIds.add(string);
        return false;
    }

    private Task<Void> ackMessage(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return Tasks.forResult(null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("google.message_id", string);
        return MessengerIpcClient.getInstance((Context)this).sendOneWayRequest(2, bundle);
    }

    private String getMessageId(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    @VisibleForTesting
    long getAckTimeoutMillis() {
        return TimeUnit.SECONDS.toMillis(1L);
    }
}

