/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessageCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new RemoteMessageCreator();
    @SafeParcelable.Field(id=2)
    Bundle bundle;
    private Map<String, String> data;
    private Notification notification;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.bundle = bundle;
    }

    final void populateSendMessageIntent(Intent intent) {
        intent.putExtras(this.bundle);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        RemoteMessageCreator.writeToParcel(this, parcel, n);
    }

    @Nullable
    public final String getSenderId() {
        return this.bundle.getString("google.c.sender.id");
    }

    @Nullable
    public final String getFrom() {
        return this.bundle.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.bundle.getString("google.to");
    }

    @NonNull
    public final Map<String, String> getData() {
        if (this.data == null) {
            this.data = Constants.MessagePayloadKeys.extractDeveloperDefinedPayload(this.bundle);
        }
        return this.data;
    }

    @ShowFirstParty
    @Nullable
    public final byte[] getRawData() {
        return this.bundle.getByteArray("rawData");
    }

    @Nullable
    public final String getCollapseKey() {
        return this.bundle.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string = this.bundle.getString("google.message_id");
        if (string == null) {
            string = this.bundle.getString("message_id");
        }
        return string;
    }

    @Nullable
    public final String getMessageType() {
        return this.bundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.bundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.bundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string = this.bundle.getString("google.original_priority");
        if (string == null) {
            string = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(string);
    }

    public final int getPriority() {
        String string = this.bundle.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.bundle.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(string);
    }

    private final int getMessagePriority(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.notification == null && NotificationParams.isNotification(this.bundle)) {
            this.notification = new Notification(new NotificationParams(this.bundle));
        }
        return this.notification;
    }

    @KeepForSdk
    public final Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.bundle);
        return intent;
    }

    public static class Notification {
        private final String title;
        private final String titleLocKey;
        private final String[] titleLocArgs;
        private final String body;
        private final String bodyLocKey;
        private final String[] bodyLocArgs;
        private final String icon;
        private final String imageUrl;
        private final String sound;
        private final String tag;
        private final String color;
        private final String clickAction;
        private final String channelId;
        private final Uri link;
        private final String ticker;
        private final Integer notificationPriority;
        private final Integer visibility;
        private final Integer notificationCount;
        private final int[] lightSettings;
        private final Long eventTime;
        private final boolean sticky;
        private final boolean localOnly;
        private final boolean defaultSound;
        private final boolean defaultVibrateTimings;
        private final boolean defaultLightSettings;
        private final long[] vibrateTimings;

        private Notification(NotificationParams notificationParams) {
            this.title = notificationParams.getString("gcm.n.title");
            this.titleLocKey = notificationParams.getLocalizationResourceForKey("gcm.n.title");
            this.titleLocArgs = Notification.getLocalizationArgs(notificationParams, "gcm.n.title");
            this.body = notificationParams.getString("gcm.n.body");
            this.bodyLocKey = notificationParams.getLocalizationResourceForKey("gcm.n.body");
            this.bodyLocArgs = Notification.getLocalizationArgs(notificationParams, "gcm.n.body");
            this.icon = notificationParams.getString("gcm.n.icon");
            this.sound = notificationParams.getSoundResourceName();
            this.tag = notificationParams.getString("gcm.n.tag");
            this.color = notificationParams.getString("gcm.n.color");
            this.clickAction = notificationParams.getString("gcm.n.click_action");
            this.channelId = notificationParams.getString("gcm.n.android_channel_id");
            this.link = notificationParams.getLink();
            this.imageUrl = notificationParams.getString("gcm.n.image");
            this.ticker = notificationParams.getString("gcm.n.ticker");
            this.notificationPriority = notificationParams.getInteger("gcm.n.notification_priority");
            this.visibility = notificationParams.getInteger("gcm.n.visibility");
            this.notificationCount = notificationParams.getInteger("gcm.n.notification_count");
            this.sticky = notificationParams.getBoolean("gcm.n.sticky");
            this.localOnly = notificationParams.getBoolean("gcm.n.local_only");
            this.defaultSound = notificationParams.getBoolean("gcm.n.default_sound");
            this.defaultVibrateTimings = notificationParams.getBoolean("gcm.n.default_vibrate_timings");
            this.defaultLightSettings = notificationParams.getBoolean("gcm.n.default_light_settings");
            this.eventTime = notificationParams.getLong("gcm.n.event_time");
            this.lightSettings = notificationParams.getLightSettings();
            this.vibrateTimings = notificationParams.getVibrateTimings();
        }

        private static String[] getLocalizationArgs(NotificationParams notificationParams, String string) {
            Object[] objectArray = notificationParams.getLocalizationArgsForKey(string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.titleLocKey;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.titleLocArgs;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.bodyLocKey;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.bodyLocArgs;
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        @Nullable
        public Uri getImageUrl() {
            if (this.imageUrl != null) {
                return Uri.parse((String)this.imageUrl);
            }
            return null;
        }

        @Nullable
        public String getSound() {
            return this.sound;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getClickAction() {
            return this.clickAction;
        }

        @Nullable
        public String getChannelId() {
            return this.channelId;
        }

        @Nullable
        public Uri getLink() {
            return this.link;
        }

        @Nullable
        public String getTicker() {
            return this.ticker;
        }

        public boolean getSticky() {
            return this.sticky;
        }

        public boolean getLocalOnly() {
            return this.localOnly;
        }

        public boolean getDefaultSound() {
            return this.defaultSound;
        }

        public boolean getDefaultVibrateSettings() {
            return this.defaultVibrateTimings;
        }

        public boolean getDefaultLightSettings() {
            return this.defaultLightSettings;
        }

        @Nullable
        public Integer getNotificationPriority() {
            return this.notificationPriority;
        }

        @Nullable
        public Integer getVisibility() {
            return this.visibility;
        }

        @Nullable
        public Integer getNotificationCount() {
            return this.notificationCount;
        }

        @Nullable
        public Long getEventTime() {
            return this.eventTime;
        }

        @Nullable
        public int[] getLightSettings() {
            return this.lightSettings;
        }

        @Nullable
        public long[] getVibrateTimings() {
            return this.vibrateTimings;
        }
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private final Map<String, String> data = new ArrayMap();

        public Builder(@NonNull String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.bundle.putString("google.to", string);
        }

        @NonNull
        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.bundle);
            this.bundle.remove("from");
            return new RemoteMessage(bundle);
        }

        @NonNull
        public Builder addData(@NonNull String string, @Nullable String string2) {
            this.data.put(string, string2);
            return this;
        }

        @NonNull
        public Builder setData(@NonNull Map<String, String> map) {
            this.data.clear();
            this.data.putAll(map);
            return this;
        }

        @NonNull
        public Builder clearData() {
            this.data.clear();
            return this;
        }

        @ShowFirstParty
        @NonNull
        public Builder setRawData(byte[] byArray) {
            this.bundle.putByteArray("rawData", byArray);
            return this;
        }

        @NonNull
        public Builder setMessageId(@NonNull String string) {
            this.bundle.putString("google.message_id", string);
            return this;
        }

        @NonNull
        public Builder setMessageType(@Nullable String string) {
            this.bundle.putString("message_type", string);
            return this;
        }

        @NonNull
        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.bundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        @NonNull
        public Builder setCollapseKey(@Nullable String string) {
            this.bundle.putString("collapse_key", string);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

