/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.messaging.MessagingAnalytics;
import java.io.IOException;

@KeepForSdk
final class FirelogAnalyticsEvent {
    private final String eventType = Preconditions.checkNotEmpty((String)"MESSAGE_DELIVERED", (Object)"evenType must be non-null");
    private final Intent intent;

    FirelogAnalyticsEvent(@NonNull String string, @NonNull Intent intent) {
        this.intent = (Intent)Preconditions.checkNotNull((Object)intent, (Object)"intent must be non-null");
    }

    @NonNull
    Intent getIntent() {
        return this.intent;
    }

    @NonNull
    String getEventType() {
        return this.eventType;
    }

    static final class FirelogAnalyticsEventWrapperEncoder
    implements ObjectEncoder<FirelogAnalyticsEventWrapper> {
        FirelogAnalyticsEventWrapperEncoder() {
        }

        public void encode(FirelogAnalyticsEventWrapper firelogAnalyticsEventWrapper, ObjectEncoderContext objectEncoderContext) throws EncodingException, IOException {
            objectEncoderContext.add("messaging_client_event", (Object)firelogAnalyticsEventWrapper.getFirelogAnalyticsEvent());
        }
    }

    static final class FirelogAnalyticsEventWrapper {
        private final FirelogAnalyticsEvent firelogAnalyticsEvent;

        FirelogAnalyticsEventWrapper(@NonNull FirelogAnalyticsEvent firelogAnalyticsEvent) {
            this.firelogAnalyticsEvent = (FirelogAnalyticsEvent)Preconditions.checkNotNull((Object)firelogAnalyticsEvent);
        }

        @NonNull
        FirelogAnalyticsEvent getFirelogAnalyticsEvent() {
            return this.firelogAnalyticsEvent;
        }
    }

    static class FirelogAnalyticsEventEncoder
    implements ObjectEncoder<FirelogAnalyticsEvent> {
        FirelogAnalyticsEventEncoder() {
        }

        public void encode(FirelogAnalyticsEvent object, ObjectEncoderContext objectEncoderContext) throws EncodingException, IOException {
            Object object2 = ((FirelogAnalyticsEvent)object).getIntent();
            objectEncoderContext.add("ttl", MessagingAnalytics.getTtl((Intent)object2));
            objectEncoderContext.add("event", (Object)((FirelogAnalyticsEvent)object).getEventType());
            objectEncoderContext.add("instanceId", (Object)MessagingAnalytics.getInstanceId());
            objectEncoderContext.add("priority", MessagingAnalytics.getPriority((Intent)object2));
            objectEncoderContext.add("packageName", (Object)MessagingAnalytics.getPackageName());
            objectEncoderContext.add("sdkPlatform", (Object)"ANDROID");
            objectEncoderContext.add("messageType", (Object)MessagingAnalytics.getMessageTypeForFirelog((Intent)object2));
            object = MessagingAnalytics.getMessageId((Intent)object2);
            if (object != null) {
                objectEncoderContext.add("messageId", object);
            }
            if ((object = MessagingAnalytics.getTopic((Intent)object2)) != null) {
                objectEncoderContext.add("topic", object);
            }
            if ((object = MessagingAnalytics.getCollapseKey((Intent)object2)) != null) {
                objectEncoderContext.add("collapseKey", object);
            }
            if (MessagingAnalytics.getMessageLabel((Intent)object2) != null) {
                objectEncoderContext.add("analyticsLabel", (Object)MessagingAnalytics.getMessageLabel((Intent)object2));
            }
            if (MessagingAnalytics.getComposerLabel((Intent)object2) != null) {
                objectEncoderContext.add("composerLabel", (Object)MessagingAnalytics.getComposerLabel((Intent)object2));
            }
            if ((object2 = MessagingAnalytics.getProjectNumber()) != null) {
                objectEncoderContext.add("projectNumber", object2);
                return;
            }
        }
    }
}

