/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_messaging.zzg;
import com.google.android.gms.internal.firebase_messaging.zzh;
import com.google.android.gms.internal.firebase_messaging.zzo;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.ImageDownload$$Lambda$0;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ImageDownload
implements Closeable {
    private final URL url;
    @Nullable
    private Task<Bitmap> task;
    @Nullable
    private volatile InputStream connectionInputStream;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ImageDownload create(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            return new ImageDownload(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            string = String.valueOf(string);
            String string2 = "Not downloading image, bad URL: ";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            Log.w((String)"FirebaseMessaging", (String)string);
            return null;
        }
    }

    private ImageDownload(URL uRL) {
        this.url = uRL;
    }

    public void start(Executor executor) {
        ImageDownload$$Lambda$0 imageDownload$$Lambda$0 = new ImageDownload$$Lambda$0(this);
        this.task = Tasks.call((Executor)executor, (Callable)imageDownload$$Lambda$0);
    }

    public Task<Bitmap> getTask() {
        return (Task)Preconditions.checkNotNull(this.task);
    }

    public Bitmap blockingDownload() throws IOException {
        Object object;
        Object object2 = String.valueOf(((ImageDownload)object).url);
        String string = String.valueOf(object2);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 22);
        stringBuilder.append("Starting download of: ");
        stringBuilder.append((String)object2);
        Log.i((String)"FirebaseMessaging", (String)stringBuilder.toString());
        object2 = ((ImageDownload)object).blockingDownloadBytes();
        object2 = BitmapFactory.decodeByteArray((byte[])object2, (int)0, (int)((Object)object2).length);
        if (object2 == null) {
            object = String.valueOf(((ImageDownload)object).url);
            String string2 = String.valueOf(object);
            int n2 = string2.length();
            stringBuilder = new StringBuilder(n2 + 24);
            stringBuilder.append("Failed to decode image: ");
            stringBuilder.append((String)object);
            object2 = new IOException(stringBuilder.toString());
            throw object2;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object = String.valueOf(((ImageDownload)object).url);
            String string3 = String.valueOf(object);
            int n3 = string3.length();
            stringBuilder = new StringBuilder(n3 + 31);
            stringBuilder.append("Successfully downloaded image: ");
            stringBuilder.append((String)object);
            Log.d((String)"FirebaseMessaging", (String)stringBuilder.toString());
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] blockingDownloadBytes() throws IOException {
        byte[] byArray;
        Object object2;
        Object object;
        block6: {
            object2 = ((ImageDownload)object).url.openConnection();
            if (((URLConnection)object2).getContentLength() > 0x100000) {
                object = new IOException("Content-Length exceeds max size of 1048576");
                throw object;
            }
            object2 = ((URLConnection)object2).getInputStream();
            try {
                ((ImageDownload)object).connectionInputStream = object2;
                byArray = zzg.zza(zzg.zzb((InputStream)object2, 0x100001L));
                if (object2 == null) break block6;
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((InputStream)object2).close();
                }
                catch (Throwable throwable2) {
                    zzo.zza(throwable, throwable2);
                    throw throwable;
                }
                throw throwable;
            }
            ((InputStream)object2).close();
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)2)) {
            object = String.valueOf(((ImageDownload)object).url);
            object2 = String.valueOf(object);
            int n = ((String)object2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 34);
            stringBuilder.append("Downloaded ");
            stringBuilder.append(byArray.length);
            stringBuilder.append(" bytes from ");
            stringBuilder.append((String)object);
            Log.v((String)"FirebaseMessaging", (String)stringBuilder.toString());
        }
        if (byArray.length <= 0x100000) return byArray;
        object = new IOException("Image exceeds max size of 1048576");
        throw object;
    }

    @Override
    public void close() {
        try {
            Closeable closeable = closeable.connectionInputStream;
            zzh.zza((InputStream)closeable);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to close the image download stream.", (Throwable)nullPointerException);
            return;
        }
    }
}

