/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_messaging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase_messaging.zzo;
import com.google.android.gms.internal.firebase_messaging.zzp;
import com.google.android.gms.internal.firebase_messaging.zzq;
import com.google.android.gms.internal.firebase_messaging.zzs;
import com.google.android.gms.internal.firebase_messaging.zzt;
import com.google.android.gms.internal.firebase_messaging.zzy;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

final class zzu
implements ObjectEncoderContext {
    private static final Charset zza = Charset.forName("UTF-8");
    private static final FieldDescriptor zzb;
    private static final FieldDescriptor zzc;
    private static final ObjectEncoder<Map.Entry<Object, Object>> zzd;
    private OutputStream zze;
    private final Map<Class<?>, ObjectEncoder<?>> zzf;
    private final Map<Class<?>, ValueEncoder<?>> zzg;
    private final ObjectEncoder<Object> zzh;
    private final zzy zzi;

    private static int zzh(FieldDescriptor object) {
        if ((object = (zzs)object.getProperty(zzs.class)) == null) {
            object = new EncodingException("Field has no @Protobuf config");
            throw object;
        }
        return object.zza();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> long zzi(ObjectEncoder<T> objectEncoder, T t) throws IOException {
        zzp zzp2 = new zzp();
        OutputStream outputStream = this.zze;
        this.zze = zzp2;
        {
            catch (Throwable throwable) {
                try {
                    zzp2.close();
                }
                finally {
                    throw throwable;
                }
            }
        }
        objectEncoder.encode(t, (Object)this);
        this.zze = outputStream;
        long l = zzp2.zza();
        zzp2.close();
        return l;
        catch (Throwable throwable) {
            this.zze = outputStream;
            throw throwable;
        }
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, double d) throws IOException {
        this.zza(fieldDescriptor, d, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, float f) throws IOException {
        this.zzb(fieldDescriptor, f, true);
        return this;
    }

    @NonNull
    public final /* synthetic */ ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, int n) throws IOException {
        this.zzd(fieldDescriptor, n, true);
        return this;
    }

    @NonNull
    public final /* synthetic */ ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, long l) throws IOException {
        this.zze(fieldDescriptor, l, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, @Nullable Object object) throws IOException {
        this.zzc(fieldDescriptor, object, true);
        return this;
    }

    @NonNull
    public final /* synthetic */ ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, boolean bl) throws IOException {
        this.zzd(fieldDescriptor, bl ? 1 : 0, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, double d) throws IOException {
        this.zza(FieldDescriptor.of((String)string), d, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, int n) throws IOException {
        this.zzd(FieldDescriptor.of((String)string), n, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, long l) throws IOException {
        this.zze(FieldDescriptor.of((String)string), l, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, @Nullable Object object) throws IOException {
        this.zzc(FieldDescriptor.of((String)string), object, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, boolean bl) throws IOException {
        this.zzd(FieldDescriptor.of((String)string), bl ? 1 : 0, true);
        return this;
    }

    final ObjectEncoderContext zza(@NonNull FieldDescriptor fieldDescriptor, double d, boolean bl) throws IOException {
        if (bl && d == 0.0) {
            return this;
        }
        this.zzn(zzu.zzh(fieldDescriptor) << 3 | 1);
        this.zze.write(zzu.zzm(8).putDouble(d).array());
        return this;
    }

    final ObjectEncoderContext zzb(@NonNull FieldDescriptor fieldDescriptor, float f, boolean bl) throws IOException {
        if (bl && f == 0.0f) {
            return this;
        }
        this.zzn(zzu.zzh(fieldDescriptor) << 3 | 5);
        this.zze.write(zzu.zzm(4).putFloat(f).array());
        return this;
    }

    final ObjectEncoderContext zzc(@NonNull FieldDescriptor object, @Nullable Object object2, boolean bl) throws IOException {
        if (object2 == null) {
            return this;
        }
        if (object2 instanceof CharSequence) {
            object2 = (CharSequence)object2;
            if (bl && object2.length() == 0) {
                return this;
            }
            this.zzn(zzu.zzh(object) << 3 | 2);
            object = object2.toString().getBytes(zza);
            this.zzn(((FieldDescriptor)object).length);
            this.zze.write((byte[])object);
            return this;
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator();
            while (object2.hasNext()) {
                this.zzc((FieldDescriptor)object, object2.next(), false);
            }
            return this;
        }
        if (object2 instanceof Map) {
            for (Object object3 : ((Map)object2).entrySet()) {
                Map.Entry entry = (Map.Entry)object3;
                this.zzk((ObjectEncoder)zzd, (FieldDescriptor)object, (Object)entry, false);
            }
            return this;
        }
        if (object2 instanceof Double) {
            this.zza((FieldDescriptor)object, (Double)object2, bl);
            return this;
        }
        if (object2 instanceof Float) {
            this.zzb((FieldDescriptor)object, ((Float)object2).floatValue(), bl);
            return this;
        }
        if (object2 instanceof Number) {
            this.zze((FieldDescriptor)object, ((Number)object2).longValue(), bl);
            return this;
        }
        if (object2 instanceof Boolean) {
            this.zzd((FieldDescriptor)object, ((Boolean)object2).booleanValue() ? 1 : 0, bl);
            return this;
        }
        if (object2 instanceof byte[]) {
            object2 = (byte[])object2;
            if (bl && ((Object)object2).length == 0) {
                return this;
            }
            this.zzn(zzu.zzh(object) << 3 | 2);
            this.zzn(((Object)object2).length);
            this.zze.write((byte[])object2);
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.zzf.get(object2.getClass());
        if (objectEncoder != null) {
            this.zzk((ObjectEncoder)objectEncoder, (FieldDescriptor)object, (Object)object2, bl);
            return this;
        }
        objectEncoder = this.zzg.get(object2.getClass());
        if (objectEncoder != null) {
            this.zzl((ValueEncoder)objectEncoder, (FieldDescriptor)object, (Object)object2, bl);
            return this;
        }
        if (object2 instanceof zzq) {
            this.zzd((FieldDescriptor)object, ((zzq)object2).getNumber(), true);
            return this;
        }
        if (object2 instanceof Enum) {
            this.zzd((FieldDescriptor)object, ((Enum)object2).ordinal(), true);
            return this;
        }
        this.zzk((ObjectEncoder)this.zzh, (FieldDescriptor)object, (Object)object2, bl);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext inline(@Nullable Object object) throws IOException {
        this.zzf(object);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext nested(@NonNull FieldDescriptor fieldDescriptor) throws IOException {
        zzu zzu2 = new EncodingException("nested() is not implemented for protobuf encoding.");
        throw zzu2;
    }

    @NonNull
    public final ObjectEncoderContext nested(@NonNull String string) throws IOException {
        return this.nested(FieldDescriptor.of((String)string));
    }

    private static zzs zzj(FieldDescriptor object) {
        if ((object = (zzs)object.getProperty(zzs.class)) == null) {
            object = new EncodingException("Field has no @Protobuf config");
            throw object;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzu zzd(@NonNull FieldDescriptor object, int n, boolean bl) throws IOException {
        if (bl) {
            if (n == 0) return this;
        }
        object = zzu.zzj((FieldDescriptor)object);
        switch (object.zzb().ordinal()) {
            case 2: {
                this.zzn(object.zza() << 3 | 5);
                this.zze.write(zzu.zzm(4).putInt(n).array());
                return this;
            }
            case 1: {
                this.zzn(object.zza() << 3);
                this.zzn(n + n ^ n >> 31);
                return this;
            }
            case 0: {
                this.zzn(object.zza() << 3);
                this.zzn(n);
                return this;
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzu zze(@NonNull FieldDescriptor object, long l, boolean bl) throws IOException {
        if (bl) {
            if (l == 0L) return this;
        }
        object = zzu.zzj((FieldDescriptor)object);
        switch (object.zzb().ordinal()) {
            case 2: {
                this.zzn(object.zza() << 3 | 1);
                this.zze.write(zzu.zzm(8).putLong(l).array());
                return this;
            }
            case 1: {
                this.zzn(object.zza() << 3);
                this.zzo(l + l ^ l >> 63);
                return this;
            }
            case 0: {
                this.zzn(object.zza() << 3);
                this.zzo(l);
                return this;
            }
        }
        return this;
    }

    private final <T> zzu zzk(ObjectEncoder<T> objectEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        long l = this.zzi(objectEncoder, t);
        if (bl && l == 0L) {
            return this;
        }
        this.zzn(zzu.zzh(fieldDescriptor) << 3 | 2);
        this.zzo(l);
        objectEncoder.encode(t, (Object)this);
        return this;
    }

    private final <T> zzu zzl(ValueEncoder<T> valueEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        this.zzi.zza(fieldDescriptor, bl);
        valueEncoder.encode(t, (Object)this.zzi);
        return this;
    }

    final zzu zzf(@Nullable Object object) throws IOException {
        if (object == null) {
            return zzu2;
        }
        ObjectEncoder<?> objectEncoder = zzu2.zzf.get(object.getClass());
        if (objectEncoder == null) {
            object = String.valueOf(object.getClass());
            String.valueOf(object).length();
            zzu zzu2 = new EncodingException("No encoder for ".concat(String.valueOf(object)));
            throw zzu2;
        }
        objectEncoder.encode(object, (Object)zzu2);
        return zzu2;
    }

    private static ByteBuffer zzm(int n) {
        return ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
    }

    static {
        FieldDescriptor.Builder builder = FieldDescriptor.builder((String)"key");
        zzo zzo2 = new zzo();
        zzo2.zza(1);
        zzb = builder.withProperty((Annotation)zzo2.zzb()).build();
        builder = FieldDescriptor.builder((String)"value");
        zzo2 = new zzo();
        zzo2.zza(2);
        zzc = builder.withProperty((Annotation)zzo2.zzb()).build();
        zzd = zzt.zza;
    }

    zzu(OutputStream outputStream, Map<Class<?>, ObjectEncoder<?>> map, Map<Class<?>, ValueEncoder<?>> map2, ObjectEncoder<Object> objectEncoder) {
        zzy zzy2;
        this.zzi = zzy2 = new zzy(this);
        this.zze = outputStream;
        this.zzf = map;
        this.zzg = map2;
        this.zzh = objectEncoder;
    }

    static /* synthetic */ void zzg(Map.Entry entry, ObjectEncoderContext objectEncoderContext) throws IOException {
        objectEncoderContext.add(zzb, entry.getKey());
        objectEncoderContext.add(zzc, entry.getValue());
    }

    private final void zzn(int n) throws IOException {
        while ((long)(n & 0xFFFFFF80) != 0L) {
            this.zze.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.zze.write(n & 0x7F);
    }

    private final void zzo(long l) throws IOException {
        long l2 = l;
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.zze.write((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
        this.zze.write((int)l2 & 0x7F);
    }
}

