/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cloudmessaging.Rpc;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.messaging.GmsRpc$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.GmsRpc$$ExternalSyntheticLambda1;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class GmsRpc {
    private final FirebaseApp app;
    private final Metadata metadata;
    private final Rpc rpc;
    private final Provider<UserAgentPublisher> userAgentPublisher;
    private final Provider<HeartBeatInfo> heartbeatInfo;
    private final FirebaseInstallationsApi firebaseInstallations;

    Task<?> deleteToken() {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        return this.extractResponseWhenComplete(this.startRpc(Metadata.getDefaultSenderId(this.app), "*", bundle));
    }

    private Task<String> extractResponseWhenComplete(Task<Bundle> task) {
        GmsRpc$$ExternalSyntheticLambda1 gmsRpc$$ExternalSyntheticLambda1 = GmsRpc$$ExternalSyntheticLambda1.INSTANCE;
        GmsRpc$$ExternalSyntheticLambda0 gmsRpc$$ExternalSyntheticLambda0 = new GmsRpc$$ExternalSyntheticLambda0(this);
        return task.continueWith((Executor)gmsRpc$$ExternalSyntheticLambda1, (Continuation)gmsRpc$$ExternalSyntheticLambda0);
    }

    Task<String> getToken() {
        Object object = this.app;
        object = Metadata.getDefaultSenderId(object);
        Bundle bundle = new Bundle();
        return this.extractResponseWhenComplete(this.startRpc((String)object, "*", bundle));
    }

    private Task<Bundle> startRpc(String string, String string2, Bundle bundle) {
        try {
            this.setDefaultAttributesToBundle(string, string2, bundle);
        }
        catch (InterruptedException | ExecutionException exception) {
            return Tasks.forException((Exception)exception);
        }
        return this.rpc.send(bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    Task<?> subscribeToTopic(String string, String string2) {
        Bundle bundle = new Bundle();
        String string3 = String.valueOf(string2);
        String string4 = "/topics/";
        string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
        bundle.putString("gcm.topic", string3);
        string2 = String.valueOf(string2);
        string3 = "/topics/";
        if (string2.length() != 0) {
            string2 = string3.concat(string2);
            return this.extractResponseWhenComplete(this.startRpc(string, string2, bundle));
        }
        string2 = new String(string3);
        return this.extractResponseWhenComplete(this.startRpc(string, string2, bundle));
    }

    /*
     * Enabled aggressive block sorting
     */
    Task<?> unsubscribeFromTopic(String string, String string2) {
        Bundle bundle = new Bundle();
        String string3 = String.valueOf(string2);
        String string4 = "/topics/";
        string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
        bundle.putString("gcm.topic", string3);
        bundle.putString("delete", "1");
        string2 = String.valueOf(string2);
        string3 = "/topics/";
        if (string2.length() != 0) {
            string2 = string3.concat(string2);
            return this.extractResponseWhenComplete(this.startRpc(string, string2, bundle));
        }
        string2 = new String(string3);
        return this.extractResponseWhenComplete(this.startRpc(string, string2, bundle));
    }

    private static String base64UrlSafe(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private String getHashedFirebaseAppName() {
        Object object = ((GmsRpc)object).app.getName();
        String string = "SHA-1";
        try {
            object = GmsRpc.base64UrlSafe(MessageDigest.getInstance(string).digest(((String)object).getBytes()));
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "[HASH-ERROR]";
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @AnyThread
    private String handleResponse(Bundle object) throws IOException {
        Object object2;
        if (object == null) {
            object2 = new IOException("SERVICE_NOT_AVAILABLE");
            throw object2;
        }
        object2 = object.getString("registration_id");
        if (object2 != null) {
            return object2;
        }
        object2 = object.getString("unregistered");
        if (object2 != null) {
            return object2;
        }
        object2 = object.getString("error");
        if ("RST".equals(object2)) {
            object2 = new IOException("INSTANCE_ID_RESET");
            throw object2;
        }
        if (object2 == null) {
            object2 = object.toString();
            Throwable throwable = new Throwable();
            Log.w((String)"FirebaseMessaging", (String)"Unexpected response: ".concat((String)object2), (Throwable)throwable);
            object2 = new IOException("SERVICE_NOT_AVAILABLE");
            throw object2;
        }
        IOException iOException = new IOException((String)object2);
        throw iOException;
    }

    /* synthetic */ String lambda$extractResponseWhenComplete$0$com-google-firebase-messaging-GmsRpc(Task task) throws Exception {
        return this.handleResponse((Bundle)task.getResult(IOException.class));
    }

    GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        Rpc rpc = new Rpc(firebaseApp.getApplicationContext());
        this(firebaseApp, metadata, rpc, provider, provider2, firebaseInstallationsApi);
    }

    @VisibleForTesting
    GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Rpc rpc, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        this.app = firebaseApp;
        this.metadata = metadata;
        this.rpc = rpc;
        this.userAgentPublisher = provider;
        this.heartbeatInfo = provider2;
        this.firebaseInstallations = firebaseInstallationsApi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDefaultAttributesToBundle(String string, String string2, Bundle bundle) throws ExecutionException, InterruptedException {
        block4: {
            bundle.putString("scope", string2);
            bundle.putString("sender", string);
            bundle.putString("subtype", string);
            bundle.putString("gmp_app_id", gmsRpc.app.getOptions().getApplicationId());
            bundle.putString("gmsv", Integer.toString(gmsRpc.metadata.getGmsVersionCode()));
            bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
            bundle.putString("app_ver", gmsRpc.metadata.getAppVersionCode());
            bundle.putString("app_ver_name", gmsRpc.metadata.getAppVersionName());
            bundle.putString("firebase-app-name-hash", gmsRpc.getHashedFirebaseAppName());
            string = ((InstallationTokenResult)Tasks.await((Task)gmsRpc.firebaseInstallations.getToken(false))).getToken();
            boolean bl = TextUtils.isEmpty((CharSequence)string);
            if (bl) break block4;
            bundle.putString("Goog-Firebase-Installations-Auth", string);
        }
        try {
            Log.w((String)"FirebaseMessaging", (String)"FIS auth token is empty");
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to get FIS auth token", (Throwable)exception);
        }
        bundle.putString("appid", (String)Tasks.await((Task)gmsRpc.firebaseInstallations.getId()));
        bundle.putString("cliv", "fcm-23.0.0");
        string = (HeartBeatInfo)gmsRpc.heartbeatInfo.get();
        GmsRpc gmsRpc = (UserAgentPublisher)gmsRpc.userAgentPublisher.get();
        if (string != null && gmsRpc != null && (string = string.getHeartBeatCode("fire-iid")) != HeartBeatInfo.HeartBeat.NONE) {
            bundle.putString("Firebase-Client-Log-Type", Integer.toString(string.getCode()));
            bundle.putString("Firebase-Client", gmsRpc.getUserAgent());
            return;
        }
    }

    static boolean isErrorMessageForRetryableError(String string) {
        return "SERVICE_NOT_AVAILABLE".equals(string) || "INTERNAL_SERVER_ERROR".equals(string) || "InternalServerError".equals(string);
    }
}

