/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.ProxyNotificationInitializer$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.ProxyNotificationInitializer$$ExternalSyntheticLambda1;
import com.google.firebase.messaging.ProxyNotificationPreferences;
import java.util.concurrent.Executor;

final class ProxyNotificationInitializer {
    @TargetApi(value=29)
    static Task<Void> setEnableProxyNotification(Executor executor, Context context, boolean bl) {
        if (!PlatformVersion.isAtLeastQ()) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ProxyNotificationInitializer$$ExternalSyntheticLambda0 proxyNotificationInitializer$$ExternalSyntheticLambda0 = new ProxyNotificationInitializer$$ExternalSyntheticLambda0(context, bl, taskCompletionSource);
        executor.execute(proxyNotificationInitializer$$ExternalSyntheticLambda0);
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    static void initialize(Context context) {
        if (ProxyNotificationPreferences.isProxyNotificationInitialized(context)) {
            return;
        }
        ProxyNotificationInitializer.setEnableProxyNotification(ProxyNotificationInitializer$$ExternalSyntheticLambda1.INSTANCE, context, ProxyNotificationInitializer.shouldEnableProxyNotification(context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ void lambda$setEnableProxyNotification$0(Context object, boolean bl, TaskCompletionSource taskCompletionSource) {
        try {
            boolean bl2 = ProxyNotificationInitializer.allowedToUse((Context)object);
            if (!bl2) {
                String string = "FirebaseMessaging";
                String string2 = "error configuring notification delegate for package ";
                int n = ((String)(object = String.valueOf(object.getPackageName()))).length();
                object = n != 0 ? string2.concat((String)object) : new String(string2);
                Log.e((String)string, (String)object);
                taskCompletionSource.trySetResult(null);
                return;
            }
            ProxyNotificationPreferences.setProxyNotificationsInitialized((Context)object, true);
            object = (NotificationManager)object.getSystemService(NotificationManager.class);
            if (bl) {
                object.setNotificationDelegate("com.google.android.gms");
                return;
            } else {
                bl = "com.google.android.gms".equals(object.getNotificationDelegate());
                if (!bl) return;
                object.setNotificationDelegate(null);
            }
            return;
        }
        finally {
            taskCompletionSource.trySetResult(null);
        }
    }

    private static boolean allowedToUse(Context context) {
        return Binder.getCallingUid() == context.getApplicationInfo().uid;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isProxyNotificationEnabled(Context object) {
        if (!PlatformVersion.isAtLeastQ()) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Platform doesn't support proxying.");
            }
            return false;
        }
        if (!ProxyNotificationInitializer.allowedToUse((Context)object)) {
            object = String.valueOf(object.getPackageName());
            String string = "error retrieving notification delegate for package ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            Log.e((String)"FirebaseMessaging", (String)object);
            return false;
        }
        if (!"com.google.android.gms".equals(((NotificationManager)object.getSystemService(NotificationManager.class)).getNotificationDelegate())) {
            return false;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"GMS core is set for proxying");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldEnableProxyNotification(Context context) {
        PackageManager packageManager;
        try {
            context = context.getApplicationContext();
            packageManager = context.getPackageManager();
            if (packageManager == null) return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return true;
        }
        context = packageManager.getApplicationInfo(context.getPackageName(), 128);
        if (context == null) return true;
        packageManager = context.metaData;
        if (packageManager == null) return true;
        boolean bl = context.metaData.containsKey("firebase_messaging_notification_delegation_enabled");
        if (!bl) return true;
        return context.metaData.getBoolean("firebase_messaging_notification_delegation_enabled");
    }
}

