/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import java.util.regex.Pattern;

final class TopicOperation {
    private static final Pattern TOPIC_NAME_REGEXP = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private final String topic;
    private final String operation;
    private final String serializedString;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.operation, this.topic};
        return Objects.hashCode((Object[])objectArray);
    }

    @Nullable
    static TopicOperation from(String stringArray) {
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return null;
        }
        if ((stringArray = stringArray.split("!", -1)).length != 2) {
            return null;
        }
        TopicOperation topicOperation = new TopicOperation(stringArray[0], stringArray[1]);
        return topicOperation;
    }

    public static TopicOperation subscribe(@NonNull String string) {
        TopicOperation topicOperation = new TopicOperation("S", string);
        return topicOperation;
    }

    public static TopicOperation unsubscribe(@NonNull String string) {
        TopicOperation topicOperation = new TopicOperation("U", string);
        return topicOperation;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getTopic() {
        return this.topic;
    }

    @NonNull
    private static String normalizeTopicOrThrow(String string, String object) {
        Object[] objectArray;
        if (string != null && string.startsWith("/topics/")) {
            objectArray = new Object[]{object};
            Log.w((String)"FirebaseMessaging", (String)String.format("Format /topics/topic-name is deprecated. Only 'topic-name' should be used in %s.", objectArray));
            string = string.substring(8);
        }
        if (string == null || !TOPIC_NAME_REGEXP.matcher(string).matches()) {
            objectArray = new Object[]{string, "[a-zA-Z0-9-_.~%]{1,900}"};
            object = new IllegalArgumentException(String.format("Invalid topic name: %s does not match the allowed format %s.", objectArray));
            throw object;
        }
        return string;
    }

    public String serialize() {
        return this.serializedString;
    }

    private TopicOperation(String string, String string2) {
        this.topic = TopicOperation.normalizeTopicOrThrow(string2, string);
        this.operation = string;
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string);
        stringBuilder.append("!");
        stringBuilder.append(string2);
        this.serializedString = stringBuilder.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof TopicOperation)) {
            return false;
        }
        object = (TopicOperation)object;
        return this.topic.equals(((TopicOperation)object).topic) && this.operation.equals(((TopicOperation)object).operation);
    }
}

