/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.TopicsSubscriber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class TopicsSyncTask
implements Runnable {
    private static final Object TOPIC_SYNC_TASK_LOCK;
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasWakeLockPermission;
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean hasAccessNetworkStatePermission;
    private final Context context;
    private final Metadata metadata;
    private final PowerManager.WakeLock syncWakeLock;
    private final TopicsSubscriber topicsSubscriber;
    private final long nextDelaySeconds;

    private static String createPermissionMissingLog(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 142);
        stringBuilder.append("Missing Permission: ");
        stringBuilder.append(string);
        stringBuilder.append(". This permission should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        return stringBuilder.toString();
    }

    static {
        Object object;
        TOPIC_SYNC_TASK_LOCK = object = new Object();
        hasWakeLockPermission = null;
        hasAccessNetworkStatePermission = null;
    }

    TopicsSyncTask(TopicsSubscriber topicsSubscriber, Context context, Metadata metadata, long l) {
        this.topicsSubscriber = topicsSubscriber;
        this.context = context;
        this.nextDelaySeconds = l;
        this.metadata = metadata;
        this.syncWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "wake:com.google.firebase.messaging");
    }

    /*
     * Exception decompiling
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 15[TRYBLOCK] [23 : 288->300)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasAccessNetworkStatePermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            Boolean bl = hasAccessNetworkStatePermission;
            boolean bl2 = bl == null ? TopicsSyncTask.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE", hasAccessNetworkStatePermission) : hasAccessNetworkStatePermission;
            hasAccessNetworkStatePermission = bl2;
            return hasAccessNetworkStatePermission;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean hasPermission(Context context, String string, Boolean bl) {
        if (bl != null) {
            return bl;
        }
        if (context.checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return bl2;
        if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) return bl2;
        Log.d((String)"FirebaseMessaging", (String)TopicsSyncTask.createPermissionMissingLog(string));
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasWakeLockPermission(Context context) {
        Object object = TOPIC_SYNC_TASK_LOCK;
        synchronized (object) {
            Boolean bl = hasWakeLockPermission;
            boolean bl2 = bl == null ? TopicsSyncTask.hasPermission(context, "android.permission.WAKE_LOCK", hasWakeLockPermission) : hasWakeLockPermission;
            hasWakeLockPermission = bl2;
            return hasWakeLockPermission;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean isDeviceConnected() {
        TopicsSyncTask topicsSyncTask = (ConnectivityManager)topicsSyncTask.context.getSystemService("connectivity");
        if (topicsSyncTask == null) return false;
        topicsSyncTask = topicsSyncTask.getActiveNetworkInfo();
        if (topicsSyncTask == null) return false;
        if (!topicsSyncTask.isConnected()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLoggable() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) return true;
        if (Build.VERSION.SDK_INT != 23) return false;
        if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) return false;
        return true;
    }

    @VisibleForTesting
    class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @GuardedBy(value="this")
        @Nullable
        private TopicsSyncTask task;

        public ConnectivityChangeReceiver(TopicsSyncTask topicsSyncTask2) {
            this.task = topicsSyncTask2;
        }

        public synchronized void onReceive(Context context, Intent object) {
            object = this.task;
            if (object == null) {
                return;
            }
            if (!((TopicsSyncTask)object).isDeviceConnected()) {
                return;
            }
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.topicsSubscriber.scheduleSyncTaskWithDelaySeconds(this.task, 0L);
            context.unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }

        public void registerReceiver() {
            if (TopicsSyncTask.isLoggable()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
            }
            TopicsSyncTask topicsSyncTask = TopicsSyncTask.this;
            topicsSyncTask = topicsSyncTask.context;
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            topicsSyncTask.registerReceiver(this, intentFilter);
        }
    }
}

