/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.ServiceStarter;
import com.google.firebase.messaging.WithinAppServiceConnection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class FcmBroadcastProcessor {
    private static final String EXTRA_BINARY_DATA = "rawData";
    private static final String EXTRA_BINARY_DATA_BASE_64 = "gcm.rawData64";
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static WithinAppServiceConnection fcmServiceConn;
    private final Context context;
    private final Executor executor;

    public FcmBroadcastProcessor(Context context) {
        this.context = context;
        this.executor = Runnable::run;
    }

    public FcmBroadcastProcessor(Context context, ExecutorService executor) {
        this.context = context;
        this.executor = executor;
    }

    @KeepForSdk
    public Task<Integer> process(Intent intent) {
        String binaryData64 = intent.getStringExtra(EXTRA_BINARY_DATA_BASE_64);
        if (binaryData64 != null) {
            intent.putExtra(EXTRA_BINARY_DATA, Base64.decode((String)binaryData64, (int)0));
            intent.removeExtra(EXTRA_BINARY_DATA_BASE_64);
        }
        return this.startMessagingService(this.context, intent);
    }

    @SuppressLint(value={"InlinedApi"})
    public Task<Integer> startMessagingService(Context context, Intent intent) {
        boolean isHighPriority;
        boolean subjectToBackgroundCheck = PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl = isHighPriority = (intent.getFlags() & 0x10000000) != 0;
        if (subjectToBackgroundCheck && !isHighPriority) {
            return FcmBroadcastProcessor.bindToMessagingService(context, intent);
        }
        Task startServiceResult = Tasks.call((Executor)this.executor, () -> ServiceStarter.getInstance().startMessagingService(context, intent));
        return startServiceResult.continueWithTask(this.executor, r -> {
            if (!PlatformVersion.isAtLeastO() || (Integer)r.getResult() != 402) {
                return r;
            }
            return FcmBroadcastProcessor.bindToMessagingService(context, intent).continueWith(Runnable::run, t -> 403);
        });
    }

    private static Task<Integer> bindToMessagingService(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Binding to service");
        }
        return FcmBroadcastProcessor.getServiceConnection(context, "com.google.firebase.MESSAGING_EVENT").sendIntent(intent).continueWith(Runnable::run, t -> -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WithinAppServiceConnection getServiceConnection(Context context, String action) {
        Object object = lock;
        synchronized (object) {
            if (fcmServiceConn == null) {
                fcmServiceConn = new WithinAppServiceConnection(context, action);
            }
            return fcmServiceConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            fcmServiceConn = null;
        }
    }
}

