/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.ServiceStarter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class SyncTask
implements Runnable {
    private final long nextDelaySeconds;
    private final PowerManager.WakeLock syncWakeLock;
    private final FirebaseMessaging firebaseMessaging;
    @VisibleForTesting
    @SuppressLint(value={"ThreadPoolCreation"})
    ExecutorService processorExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("firebase-iid-executor"));

    @VisibleForTesting
    @SuppressLint(value={"InvalidWakeLockTag"})
    public SyncTask(FirebaseMessaging firebaseMessaging, long nextDelaySeconds) {
        this.firebaseMessaging = firebaseMessaging;
        this.nextDelaySeconds = nextDelaySeconds;
        PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
        this.syncWakeLock = pm.newWakeLock(1, "fiid-sync");
        this.syncWakeLock.setReferenceCounted(false);
    }

    @Override
    @SuppressLint(value={"WakelockTimeout"})
    public void run() {
        if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
            this.syncWakeLock.acquire();
        }
        try {
            this.firebaseMessaging.setSyncScheduledOrRunning(true);
            if (!this.firebaseMessaging.isGmsCorePresent()) {
                this.firebaseMessaging.setSyncScheduledOrRunning(false);
                return;
            }
            if (ServiceStarter.getInstance().hasAccessNetworkStatePermission(this.getContext()) && !this.isDeviceConnected()) {
                ConnectivityChangeReceiver receiver = new ConnectivityChangeReceiver(this);
                receiver.registerReceiver();
                return;
            }
            if (this.maybeRefreshToken()) {
                this.firebaseMessaging.setSyncScheduledOrRunning(false);
            } else {
                this.firebaseMessaging.syncWithDelaySecondsInternal(this.nextDelaySeconds);
            }
        }
        catch (IOException e) {
            Log.e((String)"FirebaseMessaging", (String)("Topic sync or token retrieval failed on hard failure exceptions: " + e.getMessage() + ". Won't retry the operation."));
            this.firebaseMessaging.setSyncScheduledOrRunning(false);
        }
        finally {
            if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                this.syncWakeLock.release();
            }
        }
    }

    @VisibleForTesting
    boolean maybeRefreshToken() throws IOException {
        try {
            String newToken = this.firebaseMessaging.blockingGetToken();
            if (newToken == null) {
                Log.e((String)"FirebaseMessaging", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Token successfully retrieved");
            }
            return true;
        }
        catch (IOException e) {
            if (GmsRpc.isErrorMessageForRetryableError(e.getMessage())) {
                Log.w((String)"FirebaseMessaging", (String)("Token retrieval failed: " + e.getMessage() + ". Will retry token retrieval"));
                return false;
            }
            if (e.getMessage() == null) {
                Log.w((String)"FirebaseMessaging", (String)"Token retrieval failed without exception message. Will retry token retrieval");
                return false;
            }
            throw e;
        }
        catch (SecurityException e) {
            Log.w((String)"FirebaseMessaging", (String)"Token retrieval failed with SecurityException. Will retry token retrieval");
            return false;
        }
    }

    Context getContext() {
        return this.firebaseMessaging.getApplicationContext();
    }

    boolean isDeviceConnected() {
        ConnectivityManager cm = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }

    static boolean isDebugLogEnabled() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    @VisibleForTesting
    static class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @Nullable
        private SyncTask task;

        public ConnectivityChangeReceiver(SyncTask task) {
            this.task = task;
        }

        public void registerReceiver() {
            if (SyncTask.isDebugLogEnabled()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
            }
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.task.getContext().registerReceiver((BroadcastReceiver)this, intentFilter);
        }

        public void onReceive(Context context, Intent intent) {
            if (this.task == null) {
                return;
            }
            if (!this.task.isDeviceConnected()) {
                return;
            }
            if (SyncTask.isDebugLogEnabled()) {
                Log.d((String)"FirebaseMessaging", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.firebaseMessaging.enqueueTaskWithDelaySeconds(this.task, 0L);
            this.task.getContext().unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }
    }
}

