/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle zzaay;
    private Map<String, String> zzUu;
    private Notification zzbTa;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.zzaay = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzF(Intent intent) {
        intent.putExtras(this.zzaay);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.zzaay.getString("from");
    }

    public String getTo() {
        return this.zzaay.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzUu == null) {
            this.zzUu = new ArrayMap();
            for (String string : this.zzaay.keySet()) {
                Object object = this.zzaay.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzUu.put(string, string2);
            }
        }
        return this.zzUu;
    }

    public String getCollapseKey() {
        return this.zzaay.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.zzaay.getString("google.message_id");
        if (string == null) {
            string = this.zzaay.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.zzaay.getString("message_type");
    }

    public long getSentTime() {
        return this.zzaay.getLong("google.sent_time");
    }

    public int getTtl() {
        Object object = this.zzaay.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.zzbTa == null && zza.zzA(this.zzaay)) {
            this.zzbTa = new Notification(this.zzaay);
        }
        return this.zzbTa;
    }

    public static class Notification {
        private final String zzavG;
        private final String zzbTb;
        private final String[] zzbTc;
        private final String zzAE;
        private final String zzbTd;
        private final String[] zzbTe;
        private final String zzbTf;
        private final String zzbTg;
        private final String mTag;
        private final String zzaBk;
        private final String zzbTh;

        private Notification(Bundle bundle) {
            this.zzavG = zza.zzf(bundle, "gcm.n.title");
            this.zzbTb = zza.zzh(bundle, "gcm.n.title");
            this.zzbTc = this.zzj(bundle, "gcm.n.title");
            this.zzAE = zza.zzf(bundle, "gcm.n.body");
            this.zzbTd = zza.zzh(bundle, "gcm.n.body");
            this.zzbTe = this.zzj(bundle, "gcm.n.body");
            this.zzbTf = zza.zzf(bundle, "gcm.n.icon");
            this.zzbTg = zza.zzR(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.zzaBk = zza.zzf(bundle, "gcm.n.color");
            this.zzbTh = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.zzavG;
        }

        public String getTitleLocalizationKey() {
            return this.zzbTb;
        }

        public String[] getTitleLocalizationArgs() {
            return this.zzbTc;
        }

        public String getBody() {
            return this.zzAE;
        }

        public String getBodyLocalizationKey() {
            return this.zzbTd;
        }

        public String[] getBodyLocalizationArgs() {
            return this.zzbTe;
        }

        public String getIcon() {
            return this.zzbTf;
        }

        public String getSound() {
            return this.zzbTg;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.zzaBk;
        }

        public String getClickAction() {
            return this.zzbTh;
        }
    }

    public static class Builder {
        private final Bundle zzaay = new Bundle();
        private final Map<String, String> zzUu = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzaay.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzUu.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzaay);
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzUu.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzUu.clear();
            this.zzUu.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzUu.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzaay.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzaay.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.zzaay.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzaay.putString("collapse_key", string);
            return this;
        }
    }
}

