/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import java.util.Map;

public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    final int mVersionCode;
    Bundle bM;
    private Map<String, String> zzctg;
    private Notification bbb;

    RemoteMessage(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.bM = bundle;
    }

    RemoteMessage(Bundle bundle) {
        this(1, bundle);
    }

    void zzaf(Intent intent) {
        intent.putExtras(this.bM);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.bM.getString("from");
    }

    public String getTo() {
        return this.bM.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzctg == null) {
            this.zzctg = new ArrayMap();
            for (String string : this.bM.keySet()) {
                Object object = this.bM.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzctg.put(string, string2);
            }
        }
        return this.zzctg;
    }

    public String getCollapseKey() {
        return this.bM.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.bM.getString("google.message_id");
        if (string == null) {
            string = this.bM.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.bM.getString("message_type");
    }

    public long getSentTime() {
        return this.bM.getLong("google.sent_time");
    }

    public int getTtl() {
        Object object = this.bM.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.bbb == null && zza.zzac(this.bM)) {
            this.bbb = new Notification(this.bM);
        }
        return this.bbb;
    }

    public static class Notification {
        private final String Fx;
        private final String bbc;
        private final String[] bbd;
        private final String zzbfm;
        private final String bbe;
        private final String[] bbf;
        private final String bbg;
        private final String bbh;
        private final String mTag;
        private final String Lc;
        private final String bbi;

        private Notification(Bundle bundle) {
            this.Fx = zza.zzf(bundle, "gcm.n.title");
            this.bbc = zza.zzh(bundle, "gcm.n.title");
            this.bbd = this.zzj(bundle, "gcm.n.title");
            this.zzbfm = zza.zzf(bundle, "gcm.n.body");
            this.bbe = zza.zzh(bundle, "gcm.n.body");
            this.bbf = this.zzj(bundle, "gcm.n.body");
            this.bbg = zza.zzf(bundle, "gcm.n.icon");
            this.bbh = zza.zzat(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.Lc = zza.zzf(bundle, "gcm.n.color");
            this.bbi = zza.zzf(bundle, "gcm.n.click_action");
        }

        private String[] zzj(Bundle bundle, String string) {
            Object[] objectArray = zza.zzi(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        public String getTitle() {
            return this.Fx;
        }

        public String getTitleLocalizationKey() {
            return this.bbc;
        }

        public String[] getTitleLocalizationArgs() {
            return this.bbd;
        }

        public String getBody() {
            return this.zzbfm;
        }

        public String getBodyLocalizationKey() {
            return this.bbe;
        }

        public String[] getBodyLocalizationArgs() {
            return this.bbf;
        }

        public String getIcon() {
            return this.bbg;
        }

        public String getSound() {
            return this.bbh;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getColor() {
            return this.Lc;
        }

        public String getClickAction() {
            return this.bbi;
        }
    }

    public static class Builder {
        private final Bundle bM = new Bundle();
        private final Map<String, String> zzctg = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.bM.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzctg.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.bM);
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzctg.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzctg.clear();
            this.zzctg.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzctg.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.bM.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.bM.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.bM.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.bM.putString("collapse_key", string);
            return this;
        }
    }
}

