/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.app.Application;
import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzpf;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzpy;
import com.google.android.gms.internal.firebase_ml.zzqa;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.ml.common.FirebaseMLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class zzpz {
    private static final GmsLogger zzbbz = new GmsLogger("ModelResourceManager", "");
    private final zzpf zzbdf = zzpf.zzno();
    private final AtomicLong zzbdg = new AtomicLong(300000L);
    @GuardedBy(value="this")
    private final Set<zzpx> zzbdh = new HashSet<zzpx>();
    private final Set<zzpx> zzbdi = new HashSet<zzpx>();
    private final ConcurrentHashMap<zzpx, zza> zzbdj = new ConcurrentHashMap();
    public static final Component<?> zzbcb = Component.builder(zzpz.class).add(Dependency.required(Context.class)).factory(zzqa.zzbbm).build();

    private zzpz(Context context) {
        if (context instanceof Application) {
            BackgroundDetector.initialize((Application)((Application)context));
        } else {
            zzbbz.e("ModelResourceManager", "No valid Application available and auto-manage cannot work");
        }
        BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zzpy(this));
        if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) {
            this.zzbdg.set(2000L);
        }
    }

    public final synchronized void zza(@NonNull zzpx zzpx2) {
        Preconditions.checkNotNull((Object)zzpx2, (Object)"Model source can not be null");
        zzbbz.d("ModelResourceManager", "Add auto-managed model resource");
        if (this.zzbdh.contains(zzpx2)) {
            zzbbz.i("ModelResourceManager", "The model resource is already registered.");
            return;
        }
        this.zzbdh.add(zzpx2);
        zzpx zzpx3 = zzpx2;
        zzpz zzpz2 = this;
        if (zzpx3 != null) {
            zzpz2.zzbdf.zza(zzpz2.new zza(zzpx3, "OPERATION_LOAD"));
            zzpz2.zzb(zzpx3);
        }
    }

    final synchronized void zzb(zzpx zzpx2) {
        if (this.zzbdh.contains(zzpx2)) {
            this.zzc(zzpx2);
        }
    }

    private final synchronized void zznv() {
        for (zzpx zzpx2 : this.zzbdh) {
            this.zzc(zzpx2);
        }
    }

    @GuardedBy(value="this")
    private final void zzc(zzpx zzpx2) {
        zza zza2 = this.zze(zzpx2);
        this.zzbdf.zzb(zza2);
        long l = this.zzbdg.get();
        zzbbz.v("ModelResourceManager", new StringBuilder(62).append("Rescheduling modelResource release after: ").append(l).toString());
        this.zzbdf.zza(zza2, l);
    }

    public final synchronized void zzd(@Nullable zzpx zzpx2) {
        if (zzpx2 == null) {
            return;
        }
        zza zza2 = this.zze(zzpx2);
        this.zzbdf.zzb(zza2);
        this.zzbdf.zza(zza2, 0L);
    }

    private final zza zze(zzpx zzpx2) {
        this.zzbdj.putIfAbsent(zzpx2, new zza(zzpx2, "OPERATION_RELEASE"));
        return this.zzbdj.get(zzpx2);
    }

    @WorkerThread
    final void zzf(zzpx zzpx2) throws FirebaseMLException {
        if (this.zzbdi.contains(zzpx2)) {
            return;
        }
        try {
            zzpx2.zznu();
        }
        catch (RuntimeException runtimeException) {
            throw new FirebaseMLException("The load task failed", 13, runtimeException);
        }
        this.zzbdi.add(zzpx2);
    }

    final /* synthetic */ void zzaq(boolean bl) {
        boolean bl2 = bl;
        zzbbz.v("ModelResourceManager", new StringBuilder(34).append("Background state changed to: ").append(bl2).toString());
        this.zzbdg.set(bl ? 2000L : 300000L);
        this.zznv();
    }

    static final /* synthetic */ zzpz zzd(ComponentContainer componentContainer) {
        return new zzpz((Context)componentContainer.get(Context.class));
    }

    final class zza
    implements Callable<Void> {
        private final zzpx zzbdk;
        private final String zzbdl;

        zza(zzpx zzpx2, String string) {
            this.zzbdk = zzpx2;
            this.zzbdl = string;
        }

        private final Void zznx() {
            switch (this.zzbdl) {
                case "OPERATION_LOAD": {
                    zzpx zzpx2 = this.zzbdk;
                    zza zza2 = this;
                    try {
                        zza2.zzpz.this.zzf(zzpx2);
                    }
                    catch (FirebaseMLException firebaseMLException) {
                        zzbbz.e("ModelResourceManager", "Error preloading model resource", (Throwable)((Object)firebaseMLException));
                    }
                    break;
                }
                case "OPERATION_RELEASE": {
                    zzpx zzpx3 = this.zzbdk;
                    zza zza3 = this;
                    zzbbz.v("ModelResourceManager", "Releasing modelResource");
                    zzpx3.release();
                    zza3.zzpz.this.zzbdi.remove(zzpx3);
                }
            }
            return null;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal((Object)this.zzbdk, (Object)zza2.zzbdk) && Objects.equal((Object)this.zzbdl, (Object)zza2.zzbdl);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzbdk, this.zzbdl});
        }

        @Override
        public final /* synthetic */ Object call() throws Exception {
            return this.zznx();
        }
    }
}

