/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzuk;
import com.google.android.gms.internal.firebase_ml.zzvy;
import com.google.android.gms.internal.firebase_ml.zzwh;
import com.google.android.gms.internal.firebase_ml.zzxs;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzwu
extends zzuk<Long>
implements zzwh<Long>,
zzxs,
RandomAccess {
    private static final zzwu zzcfd = new zzwu(new long[0], 0);
    private long[] zzcfe;
    private int size;

    zzwu() {
        this(new long[10], 0);
    }

    private zzwu(long[] lArray, int n) {
        this.zzcfe = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzsq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcfe, n2, this.zzcfe, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzwu)) {
            return super.equals(object);
        }
        zzwu zzwu2 = (zzwu)object;
        if (this.size != zzwu2.size) {
            return false;
        }
        long[] lArray = zzwu2.zzcfe;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcfe[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvy.zzaf(this.zzcfe[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzcp(n);
        return this.zzcfe[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzag(long l) {
        this.zzsq();
        if (this.size == this.zzcfe.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcfe, 0, lArray, 0, this.size);
            this.zzcfe = lArray;
        }
        this.zzcfe[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzsq();
        zzvy.checkNotNull(collection);
        if (!(collection instanceof zzwu)) {
            return super.addAll(collection);
        }
        zzwu zzwu2 = (zzwu)collection;
        if (zzwu2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzwu2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzwu2.size;
        if (n > this.zzcfe.length) {
            this.zzcfe = Arrays.copyOf(this.zzcfe, n);
        }
        System.arraycopy(zzwu2.zzcfe, 0, this.zzcfe, this.size, zzwu2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzsq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcfe[i])) continue;
            System.arraycopy(this.zzcfe, i + 1, this.zzcfe, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzcp(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzcq(n));
        }
    }

    private final String zzcq(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzwu zzwu2 = this;
        zzwu2.zzsq();
        zzwu2.zzcp(n);
        long l3 = zzwu2.zzcfe[n];
        zzwu2.zzcfe[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzwu zzwu2 = this;
        zzwu2.zzsq();
        zzwu2.zzcp(n);
        long l = zzwu2.zzcfe[n];
        if (n < zzwu2.size - 1) {
            System.arraycopy(zzwu2.zzcfe, n + 1, zzwu2.zzcfe, n, zzwu2.size - n - 1);
        }
        --zzwu2.size;
        ++zzwu2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzwu zzwu2 = this;
        zzwu2.zzsq();
        if (n < 0 || n > zzwu2.size) {
            throw new IndexOutOfBoundsException(zzwu2.zzcq(n));
        }
        if (zzwu2.size < zzwu2.zzcfe.length) {
            System.arraycopy(zzwu2.zzcfe, n, zzwu2.zzcfe, n + 1, zzwu2.size - n);
        } else {
            long[] lArray = new long[zzwu2.size * 3 / 2 + 1];
            System.arraycopy(zzwu2.zzcfe, 0, lArray, 0, n);
            System.arraycopy(zzwu2.zzcfe, n, lArray, n + 1, zzwu2.size - n);
            zzwu2.zzcfe = lArray;
        }
        zzwu2.zzcfe[n] = l2;
        ++zzwu2.size;
        ++zzwu2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzag(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzwh zzcr(int n) {
        int n2 = n;
        zzwu zzwu2 = this;
        if (n2 < zzwu2.size) {
            throw new IllegalArgumentException();
        }
        return new zzwu(Arrays.copyOf(zzwu2.zzcfe, n2), zzwu2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzcfd.zzsp();
    }
}

