/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zzaa;
import com.google.firebase.ml.common.internal.modeldownload.zzai;
import com.google.firebase.ml.common.internal.modeldownload.zzd;
import com.google.firebase.ml.common.internal.modeldownload.zzu;
import com.google.firebase.ml.common.internal.modeldownload.zzw;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;

@WorkerThread
public final class zzad {
    private static final GmsLogger zzbbo = new GmsLogger("RmModelInfoRetriever", "");

    @WorkerThread
    @Nullable
    static zzaa zza(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzw zzw2) throws FirebaseMLException {
        zzaa zzaa2 = firebaseRemoteModel.isBaseModel() ? zzd.zza(firebaseRemoteModel, zzw2) : zzu.zza(zzpn2, zzpn2.zznq(), firebaseRemoteModel, zzw2);
        if (zzaa2 != null) {
            zzw2.zza(zznq.zzamr, false, zzaa2.zzov(), zzng.zzag.zzb.zzauq);
        }
        return zzaa2;
    }

    @Nullable
    static HttpsURLConnection zza(@Nullable String string, @NonNull zzw zzw2) throws FirebaseMLException {
        if (string == null) {
            return null;
        }
        try {
            zzai zzai2 = new zzai(string);
            String string2 = String.valueOf(string);
            zzbbo.d("RmModelInfoRetriever", string2.length() != 0 ? "Checking model URL: ".concat(string2) : new String("Checking model URL: "));
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)zzai2.openConnection();
            httpsURLConnection.setConnectTimeout(2000);
            httpsURLConnection.connect();
            int n = httpsURLConnection.getResponseCode();
            if (n != 200 && n != 304) {
                zznq zznq2 = n == 408 ? zznq.zzamz : zznq.zzanf;
                zzw2.zza(zznq2, httpsURLConnection.getResponseCode());
                InputStream inputStream = httpsURLConnection.getErrorStream();
                String string3 = inputStream == null ? "" : new String(IOUtils.readInputStreamFully((InputStream)inputStream));
                throw new FirebaseMLException(String.format(Locale.getDefault(), "Failed to connect to Firebase ML console server with HTTP status code: %d and error message: %s", httpsURLConnection.getResponseCode(), string3), 13);
            }
            return httpsURLConnection;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            zzw2.zzo(zznq.zzamz);
            throw new FirebaseMLException("Failed to get model URL due to time out", 13, socketTimeoutException);
        }
        catch (IOException iOException) {
            zznq zznq3 = zznq.zzanh;
            String string4 = "Failed to get model URL";
            if (iOException instanceof UnknownHostException) {
                zznq3 = zznq.zzanc;
                string4 = "Failed to retrieve model info due to no internet connection.";
            }
            zzw2.zzo(zznq3);
            throw new FirebaseMLException(string4, 13, iOException);
        }
    }
}

