/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zzag;
import com.google.firebase.ml.common.internal.modeldownload.zzf;
import com.google.firebase.ml.common.internal.modeldownload.zzl;
import com.google.firebase.ml.common.internal.modeldownload.zzm;
import com.google.firebase.ml.common.internal.modeldownload.zzo;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;

@WorkerThread
public class zzj {
    private static final GmsLogger zzbbo = new GmsLogger("ModelLoader", "");
    @VisibleForTesting
    @Nullable
    private final zzag zzbeb;
    @VisibleForTesting
    @Nullable
    public final zzf zzbec;
    @NonNull
    private final zzl zzbed;
    protected int zzbee = zzo.zzbel;

    public zzj(@Nullable zzag zzag2, @Nullable zzf zzf2, @NonNull zzl zzl2) {
        Preconditions.checkArgument((zzag2 != null || zzf2 != null ? 1 : 0) != 0, (Object)"At least one of RemoteModelLoader or LocalModelLoader must be non-null.");
        Preconditions.checkNotNull((Object)zzl2);
        this.zzbeb = zzag2;
        this.zzbec = zzf2;
        this.zzbed = zzl2;
    }

    public final synchronized void zza(zzm zzm2) throws FirebaseMLException {
        Throwable throwable = null;
        Throwable throwable2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<zznq> arrayList = new ArrayList<zznq>();
        try {
            bl = this.zza(zzm2, arrayList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.zzbed.zze(arrayList);
            this.zzbee = zzo.zzbem;
            return;
        }
        try {
            bl2 = this.zzb(zzm2, arrayList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            this.zzbed.zze(arrayList);
            this.zzbee = zzo.zzben;
            return;
        }
        arrayList.add(zznq.zzani);
        this.zzbed.zze(arrayList);
        this.zzbee = zzo.zzbel;
        if (throwable != null) {
            String string = String.valueOf(this.zzoe());
            throw new FirebaseMLException(string.length() != 0 ? "Remote model load failed with the model options: ".concat(string) : new String("Remote model load failed with the model options: "), 14, throwable);
        }
        if (throwable2 != null) {
            String string = String.valueOf(this.zzoe());
            throw new FirebaseMLException(string.length() != 0 ? "Local model load failed with the model options: ".concat(string) : new String("Local model load failed with the model options: "), 14, throwable2);
        }
        String string = String.valueOf(this.zzoe());
        throw new FirebaseMLException(string.length() != 0 ? "Cannot load any model with the model options: ".concat(string) : new String("Cannot load any model with the model options: "), 14);
    }

    public final synchronized boolean zzod() {
        return this.zzbee == zzo.zzbem;
    }

    private final synchronized boolean zza(zzm zzm2, List<zznq> list) throws FirebaseMLException {
        if (this.zzbeb != null) {
            MappedByteBuffer mappedByteBuffer;
            try {
                mappedByteBuffer = this.zzbeb.load();
            }
            catch (FirebaseMLException firebaseMLException) {
                zzbbo.d("ModelLoader", "Remote model source can NOT be loaded, try local model.");
                list.add(zznq.zzanl);
                throw firebaseMLException;
            }
            if (mappedByteBuffer != null) {
                try {
                    zzm2.zza(mappedByteBuffer);
                }
                catch (RuntimeException runtimeException) {
                    list.add(zznq.zzank);
                    throw runtimeException;
                }
                zzbbo.d("ModelLoader", "Remote model source is loaded successfully");
                return true;
            }
            zzbbo.d("ModelLoader", "Remote model source can NOT be loaded, try local model.");
            list.add(zznq.zzanm);
        }
        return false;
    }

    private final synchronized boolean zzb(zzm zzm2, List<zznq> list) throws FirebaseMLException {
        MappedByteBuffer mappedByteBuffer;
        if (this.zzbec != null && (mappedByteBuffer = this.zzbec.load()) != null) {
            try {
                zzm2.zza(mappedByteBuffer);
            }
            catch (RuntimeException runtimeException) {
                list.add(zznq.zzanj);
                throw runtimeException;
            }
            zzbbo.d("ModelLoader", "Local model source is loaded successfully");
            return true;
        }
        return false;
    }

    private final String zzoe() {
        String string = null;
        if (this.zzbec != null) {
            if (this.zzbec.zzoc().getAssetFilePath() != null) {
                string = this.zzbec.zzoc().getAssetFilePath();
            } else if (this.zzbec.zzoc().getFilePath() != null) {
                string = this.zzbec.zzoc().getFilePath();
            }
        }
        String string2 = this.zzbeb == null ? "unspecified" : this.zzbeb.zzow().getUniqueModelNameForPersist();
        return String.format("Local model path: %s. Remote model name: %s. ", string, string2);
    }
}

