/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.modeldownload;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.RemoteModelManagerInterface;
import com.google.firebase.ml.common.modeldownload.FirebaseModelDownloadConditions;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FirebaseModelManager {
    private final Map<Class<? extends FirebaseRemoteModel>, Provider<? extends RemoteModelManagerInterface<? extends FirebaseRemoteModel>>> zzbgb = new HashMap<Class<? extends FirebaseRemoteModel>, Provider<? extends RemoteModelManagerInterface<? extends FirebaseRemoteModel>>>();

    @NonNull
    public static synchronized FirebaseModelManager getInstance() {
        return FirebaseModelManager.getInstance(FirebaseApp.getInstance());
    }

    @NonNull
    public static synchronized FirebaseModelManager getInstance(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotNull((Object)firebaseApp, (Object)"Please provide a valid FirebaseApp");
        return (FirebaseModelManager)firebaseApp.get(FirebaseModelManager.class);
    }

    @KeepForSdk
    public FirebaseModelManager(Set<RemoteModelManagerRegistration> set) {
        for (RemoteModelManagerRegistration remoteModelManagerRegistration : set) {
            this.zzbgb.put(remoteModelManagerRegistration.zzoy(), remoteModelManagerRegistration.zzoz());
        }
    }

    @NonNull
    public Task<Void> download(@NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull FirebaseModelDownloadConditions firebaseModelDownloadConditions) {
        Preconditions.checkNotNull((Object)firebaseRemoteModel, (Object)"FirebaseRemoteModel cannot be null");
        Preconditions.checkNotNull((Object)firebaseModelDownloadConditions, (Object)"FirebaseModelDownloadConditions cannot be null");
        if (this.zzbgb.containsKey(firebaseRemoteModel.getClass())) {
            return this.zzg(firebaseRemoteModel.getClass()).download(firebaseRemoteModel, firebaseModelDownloadConditions);
        }
        return Tasks.forException((Exception)((Object)new FirebaseMLException("Feature model doesn't have a corresponding modelmanager registered.", 13)));
    }

    @NonNull
    public Task<Void> deleteDownloadedModel(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        Preconditions.checkNotNull((Object)firebaseRemoteModel, (Object)"FirebaseRemoteModel cannot be null");
        return this.zzg(firebaseRemoteModel.getClass()).deleteDownloadedModel(firebaseRemoteModel);
    }

    @NonNull
    public Task<Boolean> isModelDownloaded(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        Preconditions.checkNotNull((Object)firebaseRemoteModel, (Object)"FirebaseRemoteModel cannot be null");
        return this.zzg(firebaseRemoteModel.getClass()).isModelDownloaded(firebaseRemoteModel);
    }

    @NonNull
    public <T extends FirebaseRemoteModel> Task<Set<T>> getDownloadedModels(@NonNull Class<T> clazz) {
        return ((RemoteModelManagerInterface)this.zzbgb.get(clazz).get()).getDownloadedModels();
    }

    private final RemoteModelManagerInterface<FirebaseRemoteModel> zzg(Class<? extends FirebaseRemoteModel> clazz) {
        return (RemoteModelManagerInterface)this.zzbgb.get(clazz).get();
    }

    @KeepForSdk
    public static class RemoteModelManagerRegistration {
        private final Class<? extends FirebaseRemoteModel> zzbgf;
        private final Provider<? extends RemoteModelManagerInterface<? extends FirebaseRemoteModel>> zzbgg;

        public <TRemote extends FirebaseRemoteModel> RemoteModelManagerRegistration(Class<TRemote> clazz, Provider<? extends RemoteModelManagerInterface<TRemote>> provider) {
            this.zzbgf = clazz;
            this.zzbgg = provider;
        }

        final Class<? extends FirebaseRemoteModel> zzoy() {
            return this.zzbgf;
        }

        final Provider<? extends RemoteModelManagerInterface<? extends FirebaseRemoteModel>> zzoz() {
            return this.zzbgg;
        }
    }
}

