/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.modeldownload;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.common.modeldownload.BaseModel;
import java.util.EnumMap;
import java.util.Map;

public class FirebaseRemoteModel {
    @Nullable
    private final String zzbdo;
    @Nullable
    private final BaseModel zzbgc;
    private static final Map<BaseModel, String> zzbgd = new EnumMap<BaseModel, String>(BaseModel.class);
    @VisibleForTesting
    private static final Map<BaseModel, String> zzbge = new EnumMap<BaseModel, String>(BaseModel.class);
    private String zzbfn;

    @KeepForSdk
    protected FirebaseRemoteModel(@Nullable String string, @Nullable BaseModel baseModel) {
        Preconditions.checkArgument((TextUtils.isEmpty((CharSequence)string) == (baseModel != null) ? 1 : 0) != 0, (Object)"One of cloud model name and base model cannot be empty");
        this.zzbdo = string;
        this.zzbgc = baseModel;
    }

    @KeepForSdk
    public String getModelNameForBackend() {
        if (this.zzbdo != null) {
            return this.zzbdo;
        }
        return zzbge.get((Object)this.zzbgc);
    }

    @KeepForSdk
    public String getUniqueModelNameForPersist() {
        if (this.zzbdo != null) {
            return this.zzbdo;
        }
        String string = String.valueOf("COM.GOOGLE.BASE_");
        String string2 = String.valueOf(zzbge.get((Object)this.zzbgc));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    @KeepForSdk
    public boolean isBaseModel() {
        return this.zzbgc != null;
    }

    @KeepForSdk
    @Nullable
    public String getModelName() {
        return this.zzbdo;
    }

    @KeepForSdk
    public boolean baseModelHashMatches(@NonNull String string) {
        if (this.zzbgc == null) {
            return false;
        }
        return string.equals(zzbgd.get((Object)this.zzbgc));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseRemoteModel)) {
            return false;
        }
        FirebaseRemoteModel firebaseRemoteModel = (FirebaseRemoteModel)object;
        return Objects.equal((Object)this.zzbdo, (Object)firebaseRemoteModel.zzbdo) && Objects.equal((Object)((Object)this.zzbgc), (Object)((Object)firebaseRemoteModel.zzbgc));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzbdo, this.zzbgc});
    }

    @KeepForSdk
    public void setModelHash(@NonNull String string) {
        this.zzbfn = string;
    }

    @KeepForSdk
    public String getModelHash() {
        return this.zzbfn;
    }

    static {
        zzbge.put(BaseModel.zzbft, "face_detector_model_m41");
        zzbge.put(BaseModel.zzbfu, "smart_reply_model_m41");
        zzbge.put(BaseModel.TRANSLATE, "translate_model_m41");
        zzbgd.put(BaseModel.zzbft, "modelHash");
        zzbgd.put(BaseModel.zzbfu, "smart_reply_model_hash");
        zzbgd.put(BaseModel.TRANSLATE, "modelHash");
    }
}

