/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.auth.api.AuthProxy;
import com.google.android.gms.auth.api.proxy.ProxyApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase_ml.zzfw;
import com.google.android.gms.internal.firebase_ml.zzfy;
import com.google.android.gms.internal.firebase_ml.zzfz;
import com.google.android.gms.internal.firebase_ml.zzhd;
import com.google.android.gms.internal.firebase_ml.zzhp;
import com.google.android.gms.internal.firebase_ml.zzht;
import com.google.android.gms.internal.firebase_ml.zzic;
import com.google.android.gms.internal.firebase_ml.zzjx;
import com.google.android.gms.internal.firebase_ml.zzjy;
import com.google.android.gms.internal.firebase_ml.zzka;
import com.google.android.gms.internal.firebase_ml.zzkb;
import com.google.android.gms.internal.firebase_ml.zzkd;
import com.google.android.gms.internal.firebase_ml.zzke;
import com.google.android.gms.internal.firebase_ml.zzkf;
import com.google.android.gms.internal.firebase_ml.zzkg;
import com.google.android.gms.internal.firebase_ml.zzkp;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzqx;
import com.google.android.gms.internal.firebase_ml.zzrb;
import com.google.android.gms.internal.firebase_ml.zzrd;
import com.google.android.gms.internal.firebase_ml.zzre;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ml.common.FirebaseMLException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class zzrc
implements zzpc<zzkd, zzqx> {
    private static final zzhd zzbkl = new zzhp();
    private static final zzht zzbkm = zzic.zzhq();
    private static final GmsLogger zzbbo = new GmsLogger("ImageAnnotatorTask", "");
    private static final Map<FirebaseApp, zzrc> zzbbn = new HashMap<FirebaseApp, zzrc>();
    private String zzbkn;
    private final boolean zzbko;
    private final GoogleApiClient zzbkg;
    private final zzkb zzbkp;
    private final String zzyh;

    public static synchronized zzrc zza(@NonNull FirebaseApp firebaseApp, boolean bl, @Nullable GoogleApiClient googleApiClient) {
        zzrc zzrc2 = zzbbn.get(firebaseApp);
        if (zzrc2 == null) {
            zzrc2 = new zzrc(firebaseApp, bl, googleApiClient);
            zzbbn.put(firebaseApp, zzrc2);
        }
        return zzrc2;
    }

    private zzrc(FirebaseApp firebaseApp, boolean bl, GoogleApiClient googleApiClient) {
        this.zzbko = bl;
        if (bl) {
            this.zzbkg = googleApiClient;
            this.zzbkp = new zzrb(this);
        } else {
            this.zzbkg = null;
            this.zzbkp = new zzre(this, zzrc.zza(firebaseApp), firebaseApp);
        }
        this.zzyh = String.format("FirebaseML_%s", firebaseApp.getName());
    }

    private static String zza(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getApiKey();
        Context context = firebaseApp.getApplicationContext();
        try {
            String string2;
            Bundle bundle;
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (bundle = applicationInfo.metaData) != null && !TextUtils.isEmpty((CharSequence)(string2 = bundle.getString("com.firebase.ml.cloud.ApiKeyForDebug")))) {
                string = string2;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(context.getPackageName());
            zzbbo.e("ImageAnnotatorTask", string3.length() != 0 ? "No such package: ".concat(string3) : new String("No such package: "), (Throwable)nameNotFoundException);
        }
        return string;
    }

    private static String zzb(Context context, String string) {
        try {
            byte[] byArray = AndroidUtilsLight.getPackageCertificateHashBytes((Context)context, (String)string);
            if (byArray == null) {
                String string2 = String.valueOf(string);
                zzbbo.e("ImageAnnotatorTask", string2.length() != 0 ? "Could not get fingerprint hash: ".concat(string2) : new String("Could not get fingerprint hash: "));
                return null;
            }
            return Hex.bytesToStringUppercase((byte[])byArray, (boolean)false);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string);
            zzbbo.e("ImageAnnotatorTask", string3.length() != 0 ? "No such package: ".concat(string3) : new String("No such package: "), (Throwable)nameNotFoundException);
            return null;
        }
    }

    @WorkerThread
    private final String getSpatulaHeader() throws FirebaseMLException {
        String string = null;
        if (!this.zzbkg.isConnected()) {
            this.zzbkg.blockingConnect(3L, TimeUnit.SECONDS);
        }
        try {
            string = ((ProxyApi.SpatulaHeaderResult)AuthProxy.ProxyApi.getSpatulaHeader(this.zzbkg).await(3L, TimeUnit.SECONDS)).getSpatulaHeader();
        }
        catch (SecurityException securityException) {}
        return string;
    }

    @WorkerThread
    public final zzkd zza(zzqx zzqx2) throws FirebaseMLException {
        zzke zzke2 = new zzke().zzb(zzqx2.features).zza(new zzkp().zze(zzqx2.zzbkd)).zza(zzqx2.imageContext);
        zzkg zzkg2 = new zzkg().zzc(Collections.singletonList(zzke2));
        try {
            zzjy zzjy2;
            List<zzkd> list;
            zzjy zzjy3 = ((zzjx)((zzfz.zza)new zzjx(zzbkl, zzbkm, new zzrd(this))).zzk(this.zzyh)).zza(this.zzbkp).zzie();
            if (this.zzbko) {
                this.zzbkn = this.getSpatulaHeader();
                if (TextUtils.isEmpty((CharSequence)this.zzbkn)) {
                    String string = "Failed to contact Google Play services for certificate fingerprint matching. Please ensure you have latest Google Play services installed";
                    zzbbo.e("ImageAnnotatorTask", string);
                    throw new FirebaseMLException(string, 14);
                }
            }
            if ((list = ((zzkf)new zzka(zzjy2 = zzjy3).zza(zzkg2).zzfj()).zzii()) != null && !list.isEmpty()) {
                return list.get(0);
            }
            throw new FirebaseMLException("Empty response from cloud vision api.", 13);
        }
        catch (zzfy zzfy2) {
            String string = String.valueOf(zzfy2.zzfc());
            zzbbo.e("ImageAnnotatorTask", new StringBuilder(44 + String.valueOf(string).length()).append("batchAnnotateImages call failed with error: ").append(string).toString());
            if (this.zzbko) {
                Log.d((String)"ImageAnnotatorTask", (String)"If you are developing / testing on a simulator, either register your development app on Firebase console or turn off enforceCertFingerprintMatch()");
            }
            zzfy zzfy3 = zzfy2;
            int n = 13;
            String string2 = zzfy3.getMessage();
            if (zzfy3.getStatusCode() == 400) {
                n = 14;
            } else if (zzfy3.zzfc() != null && zzfy3.zzfc().zzez() != null) {
                Iterator<zzfw.zza> iterator = zzfy3.zzfc().zzez().iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next().getReason();
                    if (string3 != null) {
                        if (string3.equals("rateLimitExceeded") || string3.equals("dailyLimitExceeded") || string3.equals("userRateLimitExceeded")) {
                            n = 8;
                        } else if (string3.equals("accessNotConfigured")) {
                            n = 7;
                        } else if (string3.equals("forbidden") || string3.equals("inactiveBillingState")) {
                            n = 7;
                            string2 = String.format("If you haven't set up billing, please go to Firebase console to set up billing: %s. If you are specifying a debug Api Key override and turned on Api Key restrictions, make sure the restrictions are set up correctly", "https://console.firebase.google.com/u/0/project/_/overview?purchaseBillingPlan=true");
                        }
                    }
                    if (n == 13) continue;
                }
            }
            throw new FirebaseMLException(string2, n);
        }
        catch (IOException iOException) {
            zzbbo.e("ImageAnnotatorTask", "batchAnnotateImages call failed with exception: ", (Throwable)iOException);
            throw new FirebaseMLException("Cloud Vision batchAnnotateImages call failure", 13, (Throwable)iOException);
        }
    }

    public final zzpx zznl() {
        return null;
    }

    static /* synthetic */ String zza(zzrc zzrc2) {
        return zzrc2.zzbkn;
    }

    static /* synthetic */ String zzc(Context context, String string) {
        return zzrc.zzb(context, string);
    }
}

