/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzrs;
import com.google.android.gms.internal.firebase_ml.zzrv;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.label.ImageLabel;
import com.google.android.gms.vision.label.ImageLabeler;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabel;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceImageLabelerOptions;
import java.util.ArrayList;
import java.util.List;

public final class zzrt
implements zzpc<List<FirebaseVisionImageLabel>, zzrl>,
zzpx {
    @VisibleForTesting
    private static boolean zzbjr = true;
    private static volatile Boolean zzbmy = null;
    private final Context zzbdu;
    private final FirebaseVisionOnDeviceImageLabelerOptions zzbmz;
    private final zzpo zzbfe;
    @GuardedBy(value="this")
    private ImageLabeler zzbna;

    zzrt(@NonNull zzpn zzpn2, @NonNull FirebaseVisionOnDeviceImageLabelerOptions firebaseVisionOnDeviceImageLabelerOptions) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"Context can not be null");
        Preconditions.checkNotNull((Object)firebaseVisionOnDeviceImageLabelerOptions, (Object)"FirebaseVisionOnDeviceImageLabelerOptions can not be null");
        this.zzbdu = zzpn2.getApplicationContext();
        this.zzbmz = firebaseVisionOnDeviceImageLabelerOptions;
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)1);
    }

    @WorkerThread
    private final synchronized List<FirebaseVisionImageLabel> zza(zzrl zzrl2) throws FirebaseMLException {
        if (zzbmy == null) {
            Context context = this.zzbdu;
            zzbmy = !(DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.vision.dynamite.ica") > 0 || DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.vision.dynamite.imagelabel") > 0);
        }
        if (zzbmy.booleanValue()) {
            throw new FirebaseMLException("No model is bundled. Please check your app setup to includefirebase-ml-vision-image-label-model dependency.", 14);
        }
        long l = SystemClock.elapsedRealtime();
        if (this.zzbna == null) {
            this.zza(zznq.zzanr, l, zzrl2);
            throw new FirebaseMLException("Model source is unavailable. Please load the model resource first.", 13);
        }
        if (!this.zzbna.isOperational()) {
            this.zza(zznq.zzana, l, zzrl2);
            throw new FirebaseMLException("Waiting for the label detection model to be downloaded. Please wait.", 14);
        }
        SparseArray sparseArray = this.zzbna.detect(zzrl2.zzbkx);
        ArrayList<FirebaseVisionImageLabel> arrayList = new ArrayList<FirebaseVisionImageLabel>();
        if (sparseArray != null) {
            for (int i = 0; i < sparseArray.size(); ++i) {
                int n = sparseArray.keyAt(i);
                arrayList.add(new FirebaseVisionImageLabel((ImageLabel)sparseArray.get(n)));
            }
        }
        this.zza(zznq.zzamr, l, zzrl2);
        zzbjr = false;
        return arrayList;
    }

    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    public final synchronized void zznu() {
        if (this.zzbna == null) {
            this.zzbna = new ImageLabeler.Builder(this.zzbdu).setScoreThreshold(this.zzbmz.getConfidenceThreshold()).build();
        }
    }

    @WorkerThread
    public final synchronized void release() {
        if (this.zzbna != null) {
            this.zzbna.release();
            this.zzbna = null;
        }
        zzbjr = true;
    }

    private final void zza(zznq zznq2, long l, zzrl zzrl2) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzrs zzrs2 = new zzrs(this, l2, zznq2, zzrl2);
        this.zzbfe.zza((zzpw)zzrs2, zznu.zzaod);
        zzng.zze.zza zza2 = (zzng.zze.zza)((zzvx)zzng.zze.zza.zzka().zzf(zznq2).zzr(zzbjr).zze(zzrf.zzb(zzrl2)).zzb(this.zzbmz.zzqe()).zztx());
        zzpu zzpu2 = zzrv.zzbhp;
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqw, zzpu2);
    }

    final /* synthetic */ zzng.zzab.zza zza(long l, zznq zznq2, zzrl zzrl2) {
        zzng.zzam zzam2 = (zzng.zzam)((zzvx)zzng.zzam.zzmk().zze(zzng.zzad.zzlr().zzj(l).zzk(zznq2).zzae(zzbjr).zzaf(true).zzag(true)).zzc(this.zzbmz.zzqe()).zzk(zzrf.zzb(zzrl2)).zztx());
        return zzng.zzab.zzln().zzb(zzam2);
    }
}

