/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrk;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzrw;
import com.google.android.gms.internal.firebase_ml.zzry;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.Frame;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.internal.modeldownload.zzt;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import com.google.firebase.ml.vision.automl.FirebaseAutoMLLocalModel;
import com.google.firebase.ml.vision.automl.FirebaseAutoMLRemoteModel;
import com.google.firebase.ml.vision.automl.internal.IOnDeviceAutoMLImageLabeler;
import com.google.firebase.ml.vision.automl.internal.OnDeviceAutoMLImageLabelerOptionsParcel;
import com.google.firebase.ml.vision.automl.internal.zzh;
import com.google.firebase.ml.vision.automl.internal.zzi;
import com.google.firebase.ml.vision.automl.internal.zzj;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabel;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceAutoMLImageLabelerOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzrx
implements zzpc<List<FirebaseVisionImageLabel>, zzrl>,
zzpx {
    @VisibleForTesting
    private static final AtomicBoolean zzbhb = new AtomicBoolean(true);
    private final zzpn zzbdc;
    private final FirebaseVisionOnDeviceAutoMLImageLabelerOptions zzbnd;
    private final zzpo zzbfe;
    private final FirebaseAutoMLRemoteModel zzbiq;
    private final FirebaseAutoMLLocalModel zzbia;
    private IOnDeviceAutoMLImageLabeler zzbne;
    private final AtomicBoolean zzbhe = new AtomicBoolean(false);

    zzrx(@NonNull zzpn zzpn2, @NonNull FirebaseVisionOnDeviceAutoMLImageLabelerOptions firebaseVisionOnDeviceAutoMLImageLabelerOptions) {
        this.zzbdc = zzpn2;
        this.zzbnd = firebaseVisionOnDeviceAutoMLImageLabelerOptions;
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)5);
        this.zzbiq = firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqd();
        this.zzbia = firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc();
    }

    @WorkerThread
    private final synchronized List<FirebaseVisionImageLabel> zza(zzrl zzrl2) throws FirebaseMLException {
        zzj[] zzjArray;
        Object object;
        Preconditions.checkNotNull((Object)zzrl2, (Object)"Mobile vision input can not be null");
        Preconditions.checkNotNull((Object)zzrl2.zzbkx, (Object)"Input frame can not be null");
        boolean bl = this.zzbhe.get();
        long l = SystemClock.elapsedRealtime();
        if (this.zzbne == null) {
            this.zza(zznq.zzanr, l, bl, zzrl2);
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"On device AutoML Image Labeler is not initialized.");
            throw new FirebaseMLException("Image labeler not initialized.", 13);
        }
        if (zzrl2.zzbkx.getBitmap() == null) {
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"No image data found.");
            throw new FirebaseMLException("No image data found.", 3);
        }
        try {
            object = ObjectWrapper.wrap((Object)zzrl2.zzbkx.getBitmap());
            Frame.Metadata metadata = zzrl2.zzbkx.getMetadata();
            zzjArray = this.zzbne.zza((IObjectWrapper)object, new zzrk(metadata.getWidth(), metadata.getHeight(), metadata.getId(), metadata.getTimestampMillis(), metadata.getRotation()));
        }
        catch (RemoteException remoteException) {
            this.zza(zznq.zzanr, l, bl, zzrl2);
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error calling on device auto ml inference.", (Throwable)remoteException);
            throw new FirebaseMLException("Cannot run on device automl image labeler.", 13, (Throwable)remoteException);
        }
        this.zza(zznq.zzamr, l, bl, zzrl2);
        if (zzjArray == null) {
            return new ArrayList<FirebaseVisionImageLabel>();
        }
        object = new ArrayList();
        zzj[] zzjArray2 = zzjArray;
        int n = zzjArray.length;
        for (int i = 0; i < n; ++i) {
            zzj zzj2 = zzjArray2[i];
            object.add(FirebaseVisionImageLabel.zza(zzj2));
        }
        zzbhb.set(false);
        return object;
    }

    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    public final synchronized void zznu() throws FirebaseMLException {
        try {
            if (this.zzbne == null) {
                zzi zzi2 = zzh.asInterface(DynamiteModule.load((Context)this.zzbdc.getApplicationContext(), (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_LOCAL, (String)"com.google.firebase.ml.vision.dynamite.automl").instantiate("com.google.firebase.ml.vision.automl.OnDeviceAutoMLImageLabelerCreator"));
                if (zzi2 == null) {
                    Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error when creating on device AutoML Image Labeler creator.");
                    throw new FirebaseMLException("Can not create on device AutoML Image Labeler.", 14);
                }
                IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zzbdc);
                FirebaseVisionOnDeviceAutoMLImageLabelerOptions firebaseVisionOnDeviceAutoMLImageLabelerOptions = this.zzbnd;
                String string = null;
                String string2 = null;
                String string3 = null;
                if (firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqd() != null) {
                    string = firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqd().getModelName();
                }
                if (firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc() != null) {
                    if (firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc().getAssetFilePath() != null) {
                        string2 = firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc().getAssetFilePath();
                    } else if (firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc().getFilePath() != null) {
                        string3 = firebaseVisionOnDeviceAutoMLImageLabelerOptions.zzqc().getFilePath();
                    }
                }
                this.zzbne = zzi2.newOnDeviceAutoMLImageLabeler(iObjectWrapper, new OnDeviceAutoMLImageLabelerOptionsParcel(firebaseVisionOnDeviceAutoMLImageLabelerOptions.getConfidenceThreshold(), string, string2, string3));
            }
        }
        catch (DynamiteModule.LoadingException loadingException) {
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error when loading automl module.", (Throwable)loadingException);
            throw new FirebaseMLException("Cannot load automl module. Please add dependency firebase-ml-vision-automl.", 14);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error when creating on device AutoML Image Labeler.", (Throwable)remoteException);
            throw new FirebaseMLException("Can not create on device AutoML Image Labeler.", 14, (Throwable)remoteException);
        }
        try {
            this.zzbne.zznu();
            this.zzbhe.set(this.zzbne.zzod());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error while loading the AutoML image labeling model.", (Throwable)remoteException);
            throw new FirebaseMLException("Cannot load the AutoML image labeling model.", 14, (Throwable)remoteException);
        }
    }

    public final void release() {
        try {
            if (this.zzbne != null) {
                this.zzbne.close();
            }
            zzbhb.set(true);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"ODAutoMLImgLabelerTask", (String)"Error closing on device AutoML Image Labeler", (Throwable)remoteException);
            return;
        }
    }

    @WorkerThread
    private final void zza(zznq zznq2, long l, boolean bl, zzrl zzrl2) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzrw zzrw2 = new zzrw(this, l2, zznq2, zzrl2, bl);
        this.zzbfe.zza((zzpw)zzrw2, zznu.zzaqk);
        zzng.zza.zza zza2 = (zzng.zza.zza)((zzvx)zzng.zza.zza.zzjo().zzb(zznq2).zzn(zzbhb.get()).zzb(zzrf.zzb(zzrl2)).zztx());
        zzpu zzpu2 = zzry.zzbhp;
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqs, zzpu2);
    }

    final /* synthetic */ zzng.zzab.zza zza(long l, zznq zznq2, zzrl zzrl2, boolean bl) {
        zzng.zzi.zza zza2 = zzng.zzi.zzkk().zza(zzng.zzad.zzlr().zzj(l).zzk(zznq2).zzae(zzbhb.get()).zzaf(true).zzag(true)).zzh(zzrf.zzb(zzrl2));
        if (bl && this.zzbiq != null) {
            zza2.zzd(zzt.zza((FirebaseRemoteModel)this.zzbiq, (zzn)zzn.zzbeh));
        } else if (this.zzbia != null) {
            zza2.zzd(this.zzbia.zza(zzn.zzbeh));
        }
        return zzng.zzab.zzln().zza(zza2);
    }
}

