/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpg;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrg;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzsb;
import com.google.android.gms.internal.firebase_ml.zzse;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.TextRecognizer;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.text.FirebaseVisionText;

public final class zzsc
implements zzpc<FirebaseVisionText, zzrl>,
zzpx {
    @VisibleForTesting
    static boolean zzbjr = true;
    @GuardedBy(value="this")
    private TextRecognizer zzbog;
    private final zzrg zzbjt = new zzrg();
    private final Context zzbdu;
    private final zzpo zzbfe;

    zzsc(@NonNull zzpn zzpn2) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext can not be null");
        this.zzbdu = zzpn2.getApplicationContext();
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)1);
    }

    @WorkerThread
    public final synchronized void zznu() {
        if (this.zzbog == null) {
            this.zzbog = new TextRecognizer.Builder(this.zzbdu).build();
        }
    }

    @WorkerThread
    public final synchronized void release() {
        if (this.zzbog != null) {
            this.zzbog.release();
            this.zzbog = null;
        }
        zzbjr = true;
    }

    @WorkerThread
    private final synchronized FirebaseVisionText zzd(@NonNull zzrl zzrl2) throws FirebaseMLException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzbog == null) {
            this.zza(zznq.zzanr, l, zzrl2);
            throw new FirebaseMLException("Model source is unavailable. Please load the model resource first.", 13);
        }
        if (!this.zzbog.isOperational()) {
            this.zza(zznq.zzana, l, zzrl2);
            throw new FirebaseMLException("Waiting for the text recognition model to be downloaded. Please wait.", 14);
        }
        this.zzbjt.zzc(zzrl2);
        SparseArray sparseArray = this.zzbog.detect(zzrl2.zzbkx);
        this.zza(zznq.zzamr, l, zzrl2);
        zzbjr = false;
        return new FirebaseVisionText((SparseArray<TextBlock>)sparseArray);
    }

    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    private final void zza(zznq zznq2, long l, zzrl zzrl2) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzsb zzsb2 = new zzsb(l2, zznq2, zzrl2);
        this.zzbfe.zza((zzpw)zzsb2, zznu.zzanx);
        zzng.zzg.zza zza2 = (zzng.zzg.zza)((zzvx)zzng.zzg.zza.zzkg().zzh(zznq2).zzv(zzbjr).zzg(zzrf.zzb(zzrl2)).zztx());
        zzpu zzpu2 = zzse.zzbhp;
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqy, zzpu2);
    }

    @WorkerThread
    public final /* synthetic */ Object zza(@NonNull zzpg zzpg2) throws FirebaseMLException {
        return this.zzd((zzrl)zzpg2);
    }
}

