/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.barcode.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zznu;
import com.google.android.gms.internal.firebase_ml.zzpc;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpo;
import com.google.android.gms.internal.firebase_ml.zzpu;
import com.google.android.gms.internal.firebase_ml.zzpw;
import com.google.android.gms.internal.firebase_ml.zzpx;
import com.google.android.gms.internal.firebase_ml.zzrf;
import com.google.android.gms.internal.firebase_ml.zzrg;
import com.google.android.gms.internal.firebase_ml.zzrk;
import com.google.android.gms.internal.firebase_ml.zzrl;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.barcode.internal.BarcodeDetectorOptionsParcel;
import com.google.firebase.ml.vision.barcode.internal.IBarcodeDetector;
import com.google.firebase.ml.vision.barcode.internal.zzc;
import com.google.firebase.ml.vision.barcode.internal.zzd;
import com.google.firebase.ml.vision.barcode.internal.zze;
import com.google.firebase.ml.vision.barcode.internal.zzf;
import com.google.firebase.ml.vision.barcode.internal.zzj;
import java.util.ArrayList;
import java.util.List;

public final class zza
implements zzpc<List<FirebaseVisionBarcode>, zzrl>,
zzpx {
    @VisibleForTesting
    private static boolean zzbjr = true;
    private final Context zzbdu;
    private final FirebaseVisionBarcodeDetectorOptions zzbjs;
    private final zzpo zzbfe;
    private final zzrg zzbjt = new zzrg();
    @Nullable
    private IBarcodeDetector zzbju;
    @Nullable
    private BarcodeDetector zzbjv;

    public zza(@NonNull zzpn zzpn2, @NonNull FirebaseVisionBarcodeDetectorOptions firebaseVisionBarcodeDetectorOptions) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext can not be null");
        Preconditions.checkNotNull((Object)firebaseVisionBarcodeDetectorOptions, (Object)"FirebaseVisionBarcodeDetectorOptions can not be null");
        this.zzbdu = zzpn2.getApplicationContext();
        this.zzbjs = firebaseVisionBarcodeDetectorOptions;
        this.zzbfe = zzpo.zza((zzpn)zzpn2, (int)1);
    }

    @WorkerThread
    public final synchronized void zznu() throws FirebaseMLException {
        if (this.zzbju == null) {
            this.zzbju = this.zzps();
        }
        if (this.zzbju != null) {
            try {
                this.zzbju.start();
                return;
            }
            catch (RemoteException remoteException) {
                throw new FirebaseMLException("Failed to start barcode detector pipeline.", 14, (Throwable)remoteException);
            }
        }
        if (this.zzbjv == null) {
            this.zzbjv = new BarcodeDetector.Builder(this.zzbdu).setBarcodeFormats(this.zzbjs.zzpq()).build();
        }
    }

    @VisibleForTesting
    @Nullable
    private final IBarcodeDetector zzps() throws FirebaseMLException {
        if (DynamiteModule.getLocalVersion((Context)this.zzbdu, (String)"com.google.firebase.ml.vision.dynamite.barcode") > 0) {
            try {
                return zzj.asInterface(DynamiteModule.load((Context)this.zzbdu, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_LOCAL, (String)"com.google.firebase.ml.vision.dynamite.barcode").instantiate("com.google.firebase.ml.vision.barcode.BarcodeDetectorCreator")).newBarcodeDetector(new BarcodeDetectorOptionsParcel(this.zzbjs.zzpq()));
            }
            catch (RemoteException | DynamiteModule.LoadingException throwable) {
                throw new FirebaseMLException("Failed to load barcode detector module.", 14, throwable);
            }
        }
        return null;
    }

    @WorkerThread
    public final synchronized void release() {
        if (this.zzbju != null) {
            try {
                this.zzbju.stop();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"BarcodeDetectorTask", (String)"Failed to stop barcode detector pipeline.", (Throwable)remoteException);
            }
            this.zzbju = null;
        }
        if (this.zzbjv != null) {
            this.zzbjv.release();
            this.zzbjv = null;
        }
        zzbjr = true;
    }

    @WorkerThread
    private final synchronized List<FirebaseVisionBarcode> zza(@NonNull zzrl zzrl2) throws FirebaseMLException {
        long l = SystemClock.elapsedRealtime();
        this.zzbjt.zzc(zzrl2);
        ArrayList<FirebaseVisionBarcode> arrayList = new ArrayList<FirebaseVisionBarcode>();
        if (this.zzbju != null) {
            try {
                IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)zzrl2.zzbkx);
                Frame.Metadata metadata = zzrl2.zzbkx.getMetadata();
                zzrk zzrk2 = new zzrk(metadata.getWidth(), metadata.getHeight(), metadata.getId(), metadata.getTimestampMillis(), metadata.getRotation());
                for (zzf zzf2 : (List)ObjectWrapper.unwrap((IObjectWrapper)this.zzbju.zzb(iObjectWrapper, zzrk2))) {
                    arrayList.add(new FirebaseVisionBarcode(zzf2));
                }
            }
            catch (RemoteException remoteException) {
                throw new FirebaseMLException("Failed to run barcode detector.", 14, (Throwable)remoteException);
            }
        } else if (this.zzbjv != null) {
            if (!this.zzbjv.isOperational()) {
                this.zza(zznq.zzana, l, zzrl2, null);
                throw new FirebaseMLException("Waiting for the barcode detection model to be downloaded. Please wait.", 14);
            }
            SparseArray sparseArray = this.zzbjv.detect(zzrl2.zzbkx);
            for (int i = 0; i < sparseArray.size(); ++i) {
                int n = sparseArray.keyAt(i);
                Barcode barcode = (Barcode)sparseArray.get(n);
                arrayList.add(new FirebaseVisionBarcode(new zze(barcode)));
            }
        } else {
            this.zza(zznq.zzanr, l, zzrl2, null);
            throw new FirebaseMLException("Model source is unavailable. Please load the model resource first.", 14);
        }
        this.zza(zznq.zzamr, l, zzrl2, arrayList);
        zzbjr = false;
        return arrayList;
    }

    public final zzpx zznl() {
        return this;
    }

    @WorkerThread
    private final void zza(zznq zznq2, long l, @NonNull zzrl zzrl2, @Nullable List<FirebaseVisionBarcode> list) {
        ArrayList<zzng.zzak.zza> arrayList = new ArrayList<zzng.zzak.zza>();
        ArrayList<zzng.zzak.zzb> arrayList2 = new ArrayList<zzng.zzak.zzb>();
        if (list != null) {
            for (FirebaseVisionBarcode firebaseVisionBarcode : list) {
                arrayList.add(firebaseVisionBarcode.zzpo());
                arrayList2.add(firebaseVisionBarcode.zzpp());
            }
        }
        long l2 = SystemClock.elapsedRealtime() - l;
        zzd zzd2 = new zzd(this, l2, zznq2, arrayList, arrayList2, zzrl2);
        this.zzbfe.zza((zzpw)zzd2, zznu.zzaoa);
        zzng.zzc.zza zza2 = (zzng.zzc.zza)((zzvx)zzng.zzc.zza.zzju().zzd(zznq2).zzp(zzbjr).zzc(zzrf.zzb(zzrl2)).zzb(this.zzbjs.zzpr()).zzj(arrayList).zzk(arrayList2).zztx());
        zzc zzc2 = new zzc(this);
        this.zzbfe.zza((Object)zza2, l2, zznu.zzaqu, (zzpu)zzc2);
    }

    final /* synthetic */ zzng.zzab.zza zza(long l, zznq zznq2, List list, List list2, zzrl zzrl2) {
        zzng.zzak.zzc zzc2 = zzng.zzak.zzmg().zzc(zzng.zzad.zzlr().zzj(l).zzk(zznq2).zzae(zzbjr).zzaf(true).zzag(true)).zzc(this.zzbjs.zzpr()).zzs((Iterable)list).zzt((Iterable)list2).zzi(zzrf.zzb(zzrl2));
        zza zza2 = this;
        return zzng.zzab.zzln().zzad(zza2.zzbju != null).zza(zzc2);
    }
}

