/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.Image;
import android.net.Uri;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzrh;
import com.google.android.gms.internal.firebase_ml.zzrm;
import com.google.android.gms.vision.Frame;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionImage {
    private static final zzrh zzbkt = zzrh.zzpx();
    @Nullable
    private volatile Bitmap zzbku;
    @Nullable
    private volatile ByteBuffer zzbkv;
    @Nullable
    private volatile FirebaseVisionImageMetadata zzbkw;
    @Nullable
    private volatile Frame zzbkx;
    @Nullable
    private volatile byte[] zzbky;
    private final long zzbkz = SystemClock.elapsedRealtime();

    @NonNull
    public static FirebaseVisionImage fromByteBuffer(@NonNull ByteBuffer byteBuffer, @NonNull FirebaseVisionImageMetadata firebaseVisionImageMetadata) {
        return new FirebaseVisionImage(byteBuffer, firebaseVisionImageMetadata);
    }

    @NonNull
    public static FirebaseVisionImage fromByteArray(@NonNull byte[] byArray, @NonNull FirebaseVisionImageMetadata firebaseVisionImageMetadata) {
        return new FirebaseVisionImage(byArray, firebaseVisionImageMetadata);
    }

    @NonNull
    public static FirebaseVisionImage fromBitmap(@NonNull Bitmap bitmap) {
        return new FirebaseVisionImage(bitmap);
    }

    @NonNull
    @RequiresApi(value=19)
    @TargetApi(value=19)
    public static FirebaseVisionImage fromMediaImage(@NonNull Image image, @FirebaseVisionImageMetadata.Rotation int n) {
        Preconditions.checkNotNull((Object)image, (Object)"Please provide a valid image");
        Preconditions.checkArgument((image.getFormat() == 256 || image.getFormat() == 35 ? 1 : 0) != 0, (Object)"Only JPEG and YUV_420_888 are supported now");
        Image.Plane[] planeArray = image.getPlanes();
        if (image.getFormat() == 256) {
            if (planeArray == null || planeArray.length != 1) {
                throw new IllegalArgumentException("Unexpected image format, JPEG should have exactly 1 image plane");
            }
            ByteBuffer byteBuffer = planeArray[0].getBuffer();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            if (n == 0) {
                return new FirebaseVisionImage(byArray);
            }
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            return new FirebaseVisionImage(FirebaseVisionImage.zza(bitmap, n));
        }
        return new FirebaseVisionImage(zzrh.zza(planeArray, image.getWidth(), image.getHeight()), new FirebaseVisionImageMetadata.Builder().setFormat(17).setWidth(image.getWidth()).setHeight(image.getHeight()).setRotation(n).build());
    }

    @NonNull
    public static FirebaseVisionImage fromFilePath(@NonNull Context context, @NonNull Uri uri) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"Please provide a valid Context");
        Preconditions.checkNotNull((Object)uri, (Object)"Please provide a valid imageUri");
        zzrm.zzpz();
        Bitmap bitmap = zzrm.zza(context.getContentResolver(), uri);
        return new FirebaseVisionImage(bitmap);
    }

    private FirebaseVisionImage(@NonNull ByteBuffer byteBuffer, @NonNull FirebaseVisionImageMetadata firebaseVisionImageMetadata) {
        this.zzbkv = (ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer);
        this.zzbkw = (FirebaseVisionImageMetadata)Preconditions.checkNotNull((Object)firebaseVisionImageMetadata);
    }

    private FirebaseVisionImage(@NonNull byte[] byArray, @NonNull FirebaseVisionImageMetadata firebaseVisionImageMetadata) {
        this(ByteBuffer.wrap((byte[])Preconditions.checkNotNull((Object)byArray)), firebaseVisionImageMetadata);
    }

    private FirebaseVisionImage(@NonNull Bitmap bitmap) {
        this.zzbku = (Bitmap)Preconditions.checkNotNull((Object)bitmap);
    }

    private FirebaseVisionImage(byte[] byArray) {
        this.zzbky = (byte[])Preconditions.checkNotNull((Object)byArray);
    }

    @NonNull
    public Bitmap getBitmap() {
        return this.zzpv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap zzpv() {
        if (this.zzbku != null) {
            return this.zzbku;
        }
        FirebaseVisionImage firebaseVisionImage = this;
        synchronized (firebaseVisionImage) {
            if (this.zzbku == null) {
                Bitmap bitmap;
                byte[] byArray = this.zzau(false);
                Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                FirebaseVisionImage firebaseVisionImage2 = this;
                this.zzbku = firebaseVisionImage2.zzbkw == null ? bitmap2 : FirebaseVisionImage.zza(bitmap2, firebaseVisionImage2.zzbkw.getRotation());
            }
        }
        return this.zzbku;
    }

    private static Bitmap zza(Bitmap bitmap, @FirebaseVisionImageMetadata.Rotation int n) {
        int n2;
        int n3 = n;
        switch (n3) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(29).append("Invalid rotation: ").append(n3).toString());
            }
        }
        int n4 = n2;
        if (n2 == 0) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n4);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public final Pair<byte[], Float> zze(int n, int n2) {
        byte[] byArray;
        float f;
        int n3;
        int n4;
        if (this.zzbkw != null) {
            boolean bl = this.zzbkw.getRotation() == 1 || this.zzbkw.getRotation() == 3;
            n4 = bl ? this.zzbkw.getHeight() : this.zzbkw.getWidth();
            n3 = bl ? this.zzbkw.getWidth() : this.zzbkw.getHeight();
        } else {
            n4 = this.zzpv().getWidth();
            n3 = this.zzpv().getHeight();
        }
        float f2 = Math.min((float)n / (float)n4, (float)n2 / (float)n3);
        if (f < 1.0f) {
            Bitmap bitmap = this.zzpv();
            Matrix matrix = new Matrix();
            matrix.postScale(f2, f2);
            byArray = zzrh.zza(Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this.zzbku.getWidth(), (int)this.zzbku.getHeight(), (Matrix)matrix, (boolean)true));
        } else {
            f2 = 1.0f;
            byArray = this.zzau(true);
        }
        return Pair.create((Object)byArray, (Object)Float.valueOf(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] zzau(boolean bl) {
        if (this.zzbky != null) {
            return this.zzbky;
        }
        FirebaseVisionImage firebaseVisionImage = this;
        synchronized (firebaseVisionImage) {
            if (this.zzbky != null) {
                return this.zzbky;
            }
            if (!(this.zzbkv == null || bl && this.zzbkw.getRotation() != 0)) {
                byte[] byArray = zzrh.zza(this.zzbkv);
                switch (this.zzbkw.getFormat()) {
                    case 17: {
                        break;
                    }
                    case 842094169: {
                        byArray = zzrh.zzf(byArray);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Must be one of: IMAGE_FORMAT_NV21, IMAGE_FORMAT_YV12");
                    }
                }
                byte[] byArray2 = zzrh.zza(byArray, this.zzbkw.getWidth(), this.zzbkw.getHeight());
                if (this.zzbkw.getRotation() == 0) {
                    this.zzbky = byArray2;
                }
                return byArray2;
            }
            byte[] byArray = zzrh.zza(this.zzpv());
            this.zzbky = byArray;
            return byArray;
        }
    }

    public final void zzpw() {
        if (this.zzbkv != null) {
            ByteBuffer byteBuffer = this.zzbkv;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity());
            byteBuffer.rewind();
            byteBuffer2.put(byteBuffer);
            byteBuffer.rewind();
            byteBuffer2.flip();
            this.zzbkv = byteBuffer2;
        }
    }

    public final synchronized Frame zza(boolean bl, boolean bl2) {
        Preconditions.checkArgument((!bl || !bl2 ? 1 : 0) != 0, (Object)"Can't restrict to bitmap-only and NV21 byte buffer-only");
        if (this.zzbkx == null) {
            Frame.Builder builder = new Frame.Builder();
            if (this.zzbkv != null && !bl) {
                int n;
                int n2;
                if (bl2 && this.zzbkw.getFormat() != 17) {
                    if (this.zzbkw.getFormat() == 842094169) {
                        ByteBuffer byteBuffer = this.zzbkv;
                        this.zzbkv = ByteBuffer.wrap(zzrh.zzf(zzrh.zza(byteBuffer)));
                        this.zzbkw = new FirebaseVisionImageMetadata.Builder().setFormat(17).setWidth(this.zzbkw.getWidth()).setHeight(this.zzbkw.getHeight()).setRotation(this.zzbkw.getRotation()).build();
                    } else {
                        throw new IllegalStateException("Must be one of: IMAGE_FORMAT_NV21, IMAGE_FORMAT_YV12");
                    }
                }
                int n3 = this.zzbkw.getWidth();
                int n4 = this.zzbkw.getHeight();
                switch (this.zzbkw.getFormat()) {
                    case 17: {
                        n2 = 17;
                        break;
                    }
                    case 842094169: {
                        n2 = 842094169;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                builder.setImageData(this.zzbkv, n3, n4, n2);
                int n5 = this.zzbkw.getRotation();
                switch (n5) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(new StringBuilder(29).append("Invalid rotation: ").append(n5).toString());
                    }
                }
                builder.setRotation(n);
            } else {
                builder.setBitmap(this.zzpv());
            }
            builder.setTimestampMillis(this.zzbkz);
            this.zzbkx = builder.build();
        }
        return this.zzbkx;
    }
}

