/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.common;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.vision.common.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FirebaseVisionImageMetadata {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int IMAGE_FORMAT_NV21 = 17;
    public static final int IMAGE_FORMAT_YV12 = 842094169;
    private final int width;
    private final int height;
    @Rotation
    private final int rotation;
    @ImageFormat
    private final int format;

    public FirebaseVisionImageMetadata(@NonNull FirebaseVisionImageMetadata firebaseVisionImageMetadata) {
        this.width = firebaseVisionImageMetadata.getWidth();
        this.height = firebaseVisionImageMetadata.getHeight();
        this.format = firebaseVisionImageMetadata.getFormat();
        this.rotation = firebaseVisionImageMetadata.getRotation();
    }

    private FirebaseVisionImageMetadata(int n, int n2, @Rotation int n3, @ImageFormat int n4) {
        this.width = n;
        this.height = n2;
        this.rotation = n3;
        this.format = n4;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Rotation
    public int getRotation() {
        return this.rotation;
    }

    @ImageFormat
    public int getFormat() {
        return this.format;
    }

    /* synthetic */ FirebaseVisionImageMetadata(int n, int n2, int n3, int n4, zza zza2) {
        this(n, n2, n3, n4);
    }

    public static class Builder {
        private int width;
        private int height;
        @Rotation
        private int rotation;
        @ImageFormat
        private int format;

        @NonNull
        public Builder setWidth(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Image buffer width should be positive.");
            this.width = n;
            return this;
        }

        @NonNull
        public Builder setHeight(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Image buffer height should be positive.");
            this.height = n;
            return this;
        }

        @NonNull
        public Builder setRotation(@Rotation int n) {
            Preconditions.checkArgument((n == 0 || n == 1 || n == 2 || n == 3 ? 1 : 0) != 0);
            this.rotation = n;
            return this;
        }

        @NonNull
        public Builder setFormat(@ImageFormat int n) {
            Preconditions.checkArgument((n == 842094169 || n == 17 ? 1 : 0) != 0);
            this.format = n;
            return this;
        }

        @NonNull
        public FirebaseVisionImageMetadata build() {
            return new FirebaseVisionImageMetadata(this.width, this.height, this.rotation, this.format, null);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ImageFormat {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Rotation {
    }
}

