/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.label;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzpp;
import com.google.android.gms.internal.firebase_ml.zzrq;
import com.google.android.gms.internal.firebase_ml.zzrr;
import com.google.android.gms.internal.firebase_ml.zzru;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.cloud.FirebaseVisionCloudDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.label.FirebaseVisionCloudImageLabelerOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabel;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceAutoMLImageLabelerOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceImageLabelerOptions;
import com.google.firebase.ml.vision.label.zzb;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseVisionImageLabeler
implements Closeable {
    private final zzrr zzbmn;
    private final zzrq zzbmo;
    private final zzru zzbmp;
    private final FirebaseVisionCloudImageLabelerOptions zzbmq;
    @ImageLabelerType
    private final int zzbmr;
    public static final int ON_DEVICE = 1;
    public static final int CLOUD = 2;
    public static final int ON_DEVICE_AUTOML = 3;
    @GuardedBy(value="FirebaseVisionImageLabeler.class")
    private static final Map<zzpp<FirebaseVisionOnDeviceImageLabelerOptions>, FirebaseVisionImageLabeler> zzbms = new HashMap<zzpp<FirebaseVisionOnDeviceImageLabelerOptions>, FirebaseVisionImageLabeler>();
    @GuardedBy(value="FirebaseVisionImageLabeler.class")
    private static final Map<zzpp<FirebaseVisionCloudImageLabelerOptions>, FirebaseVisionImageLabeler> zzbmt = new HashMap<zzpp<FirebaseVisionCloudImageLabelerOptions>, FirebaseVisionImageLabeler>();
    @GuardedBy(value="FirebaseVisionImageLabeler.class")
    private static final Map<zzpp<FirebaseVisionOnDeviceAutoMLImageLabelerOptions>, FirebaseVisionImageLabeler> zzbmu = new HashMap<zzpp<FirebaseVisionOnDeviceAutoMLImageLabelerOptions>, FirebaseVisionImageLabeler>();

    public static synchronized FirebaseVisionImageLabeler zza(@NonNull zzpn zzpn2, @NonNull FirebaseVisionOnDeviceImageLabelerOptions firebaseVisionOnDeviceImageLabelerOptions) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext must not be null");
        Preconditions.checkNotNull((Object)zzpn2.getPersistenceKey(), (Object)"Persistence key must not be null");
        zzpp zzpp2 = zzpp.zzj((String)zzpn2.getPersistenceKey(), (Object)firebaseVisionOnDeviceImageLabelerOptions);
        FirebaseVisionImageLabeler firebaseVisionImageLabeler = zzbms.get(zzpp2);
        if (firebaseVisionImageLabeler == null) {
            zzrq zzrq2 = new zzrq(zzpn2, firebaseVisionOnDeviceImageLabelerOptions);
            firebaseVisionImageLabeler = new FirebaseVisionImageLabeler(zzrq2);
            zzbms.put((zzpp<FirebaseVisionOnDeviceImageLabelerOptions>)zzpp2, firebaseVisionImageLabeler);
        }
        return firebaseVisionImageLabeler;
    }

    public static synchronized FirebaseVisionImageLabeler zza(@NonNull zzpn zzpn2, @NonNull FirebaseVisionOnDeviceAutoMLImageLabelerOptions firebaseVisionOnDeviceAutoMLImageLabelerOptions) throws FirebaseMLException {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext must not be null");
        Preconditions.checkNotNull((Object)zzpn2.getPersistenceKey(), (Object)"Persistence key must not be null");
        zzpp zzpp2 = zzpp.zzj((String)zzpn2.getPersistenceKey(), (Object)firebaseVisionOnDeviceAutoMLImageLabelerOptions);
        FirebaseVisionImageLabeler firebaseVisionImageLabeler = zzbmu.get(zzpp2);
        if (firebaseVisionImageLabeler == null) {
            zzru zzru2 = new zzru(zzpn2, firebaseVisionOnDeviceAutoMLImageLabelerOptions);
            firebaseVisionImageLabeler = new FirebaseVisionImageLabeler(zzru2);
            zzbmu.put((zzpp<FirebaseVisionOnDeviceAutoMLImageLabelerOptions>)zzpp2, firebaseVisionImageLabeler);
        }
        return firebaseVisionImageLabeler;
    }

    public static synchronized FirebaseVisionImageLabeler zza(@NonNull zzpn zzpn2, @NonNull FirebaseVisionCloudImageLabelerOptions firebaseVisionCloudImageLabelerOptions) {
        Preconditions.checkNotNull((Object)zzpn2, (Object)"MlKitContext must not be null");
        Preconditions.checkNotNull((Object)zzpn2.getPersistenceKey(), (Object)"Persistence key must not be null");
        zzpp zzpp2 = zzpp.zzj((String)zzpn2.getPersistenceKey(), (Object)firebaseVisionCloudImageLabelerOptions);
        FirebaseVisionImageLabeler firebaseVisionImageLabeler = zzbmt.get(zzpp2);
        if (firebaseVisionImageLabeler == null) {
            FirebaseVisionCloudDetectorOptions.Builder builder = new FirebaseVisionCloudDetectorOptions.Builder().setMaxResults(20);
            if (firebaseVisionCloudImageLabelerOptions.isEnforceCertFingerprintMatch()) {
                builder.enforceCertFingerprintMatch();
            }
            zzrr zzrr2 = new zzrr(zzpn2, builder.build());
            firebaseVisionImageLabeler = new FirebaseVisionImageLabeler(zzrr2, firebaseVisionCloudImageLabelerOptions);
            zzbmt.put((zzpp<FirebaseVisionCloudImageLabelerOptions>)zzpp2, firebaseVisionImageLabeler);
        }
        return firebaseVisionImageLabeler;
    }

    @NonNull
    public Task<List<FirebaseVisionImageLabel>> processImage(@NonNull FirebaseVisionImage firebaseVisionImage) {
        Preconditions.checkState((this.zzbmo != null || this.zzbmn != null || this.zzbmp != null ? 1 : 0) != 0, (Object)"One of on-device, cloud, or on-device AutoML image labeler should be set.");
        if (this.zzbmo != null) {
            return this.zzbmo.detectInImage(firebaseVisionImage);
        }
        if (this.zzbmp != null) {
            return this.zzbmp.detectInImage(firebaseVisionImage);
        }
        return this.zzbmn.detectInImage(firebaseVisionImage).continueWith((Continuation)new zzb(this));
    }

    @ImageLabelerType
    public int getImageLabelerType() {
        return this.zzbmr;
    }

    @Override
    public void close() throws IOException {
        if (this.zzbmo != null) {
            this.zzbmo.close();
        }
        if (this.zzbmn != null) {
            this.zzbmn.close();
        }
        if (this.zzbmp != null) {
            this.zzbmp.close();
        }
    }

    private FirebaseVisionImageLabeler(@Nullable zzrq zzrq2) {
        this(zzrq2, null, null, null);
    }

    private FirebaseVisionImageLabeler(@Nullable zzrr zzrr2, @Nullable FirebaseVisionCloudImageLabelerOptions firebaseVisionCloudImageLabelerOptions) {
        this(null, zzrr2, null, firebaseVisionCloudImageLabelerOptions);
    }

    private FirebaseVisionImageLabeler(@NonNull zzru zzru2) {
        this(null, null, zzru2, null);
    }

    private FirebaseVisionImageLabeler(@Nullable zzrq zzrq2, @Nullable zzrr zzrr2, @Nullable zzru zzru2, @Nullable FirebaseVisionCloudImageLabelerOptions firebaseVisionCloudImageLabelerOptions) {
        Preconditions.checkArgument((zzrq2 != null || zzrr2 != null || zzru2 != null ? 1 : 0) != 0, (Object)"One of on-device, cloud or on-device AutoML image labeler should be set.");
        this.zzbmo = zzrq2;
        this.zzbmn = zzrr2;
        this.zzbmq = firebaseVisionCloudImageLabelerOptions;
        this.zzbmp = zzru2;
        if (zzrr2 != null) {
            this.zzbmr = 2;
            return;
        }
        if (zzrq2 != null) {
            this.zzbmr = 1;
            return;
        }
        this.zzbmr = 3;
    }

    static /* synthetic */ FirebaseVisionCloudImageLabelerOptions zza(FirebaseVisionImageLabeler firebaseVisionImageLabeler) {
        return firebaseVisionImageLabeler.zzbmq;
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ImageLabelerType {
    }
}

