/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.objects;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.ml.vision.objects.internal.zzh;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FirebaseVisionObject {
    public static final int CATEGORY_UNKNOWN = 0;
    public static final int CATEGORY_HOME_GOOD = 1;
    public static final int CATEGORY_FASHION_GOOD = 2;
    public static final int CATEGORY_FOOD = 3;
    public static final int CATEGORY_PLACE = 4;
    public static final int CATEGORY_PLANT = 5;
    private final Rect zzbks;
    private final Integer zzbnf;
    private final Float confidence;
    @Category
    private final int category;

    public FirebaseVisionObject(@NonNull zzh zzh2) {
        Preconditions.checkNotNull((Object)((Object)zzh2), (Object)"Returned Object Detector Parcel can not be null");
        int[] nArray = zzh2.zzbnt;
        Preconditions.checkArgument((zzh2.zzbnt.length == 4 ? 1 : 0) != 0);
        this.zzbks = new Rect(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.zzbnf = zzh2.zzbnf;
        this.confidence = zzh2.confidence;
        this.category = zzh2.category;
    }

    @Category
    public int getClassificationCategory() {
        return this.category;
    }

    @NonNull
    public Rect getBoundingBox() {
        return this.zzbks;
    }

    @Nullable
    public Integer getTrackingId() {
        return this.zzbnf;
    }

    @Nullable
    public Float getClassificationConfidence() {
        return this.confidence;
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Category {
    }
}

