/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzmr;
import com.google.android.gms.vision.text.Text;
import com.google.firebase.ml.vision.text.RecognizedLanguage;
import com.google.firebase.ml.vision.text.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FirebaseVisionText {
    public static final FirebaseVisionText zzbnv = new FirebaseVisionText("", new ArrayList<TextBlock>());
    private final List<TextBlock> zzbnw = new ArrayList<TextBlock>();
    private final String text;

    @NonNull
    public List<TextBlock> getTextBlocks() {
        return Collections.unmodifiableList(this.zzbnw);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public FirebaseVisionText(@NonNull SparseArray<com.google.android.gms.vision.text.TextBlock> sparseArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sparseArray.size(); ++i) {
            com.google.android.gms.vision.text.TextBlock textBlock = (com.google.android.gms.vision.text.TextBlock)sparseArray.get(sparseArray.keyAt(i));
            if (textBlock == null) continue;
            TextBlock textBlock2 = new TextBlock(textBlock);
            this.zzbnw.add(textBlock2);
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            if (textBlock.getValue() == null) continue;
            stringBuilder.append(((TextBase)textBlock2).getText());
        }
        this.text = stringBuilder.toString();
    }

    public FirebaseVisionText(@NonNull String string, @NonNull List<TextBlock> list) {
        this.text = string;
        this.zzbnw.addAll(list);
    }

    static class TextBase {
        private final String text;
        private final Rect zzbks;
        private final Point[] cornerPoints;
        private final Float confidence;
        private final List<RecognizedLanguage> zzblo;

        TextBase(@NonNull Text text) {
            Preconditions.checkNotNull((Object)text, (Object)"Text to construct FirebaseVisionText classes can't be null");
            this.confidence = null;
            this.text = text.getValue();
            this.zzbks = text.getBoundingBox();
            this.cornerPoints = text.getCornerPoints();
            this.zzblo = zzmr.zzji();
        }

        private TextBase(@NonNull String string, @Nullable Rect rect, @NonNull List<RecognizedLanguage> list, @Nullable Float f) {
            Preconditions.checkNotNull((Object)string, (Object)"Text string cannot be null");
            Preconditions.checkNotNull(list, (Object)"Text languages cannot be null");
            this.confidence = f;
            this.cornerPoints = null;
            this.text = string;
            this.zzbks = rect;
            this.zzblo = list;
        }

        @Nullable
        public Rect getBoundingBox() {
            return this.zzbks;
        }

        @Nullable
        public Point[] getCornerPoints() {
            return this.cornerPoints;
        }

        @NonNull
        public String getText() {
            if (this.text == null) {
                return "";
            }
            return this.text;
        }

        @Nullable
        public Float getConfidence() {
            return this.confidence;
        }

        @NonNull
        public List<RecognizedLanguage> getRecognizedLanguages() {
            return this.zzblo;
        }

        /* synthetic */ TextBase(String string, Rect rect, List list, Float f, zzb zzb2) {
            this(string, rect, list, f);
        }
    }

    public static class Element
    extends TextBase {
        Element(@NonNull com.google.android.gms.vision.text.Element element) {
            super((Text)element);
        }

        public Element(@NonNull String string, @Nullable Rect rect, @NonNull List<RecognizedLanguage> list, @Nullable Float f) {
            super(string, rect, list, f, null);
        }
    }

    public static class Line
    extends TextBase {
        @GuardedBy(value="this")
        private final List<Element> zzbnx;

        Line(@NonNull com.google.android.gms.vision.text.Line line) {
            super((Text)line);
            this.zzbnx = new ArrayList<Element>();
            for (Text text : line.getComponents()) {
                if (text instanceof com.google.android.gms.vision.text.Element) {
                    this.zzbnx.add(new Element((com.google.android.gms.vision.text.Element)text));
                    continue;
                }
                Log.e((String)"FirebaseVisionText", (String)"A subcomponent of line is should be an element!");
            }
        }

        public Line(@NonNull String string, @Nullable Rect rect, @NonNull List<RecognizedLanguage> list, @NonNull List<Element> list2, @Nullable Float f) {
            super(string, rect, list, f, null);
            this.zzbnx = list2;
        }

        @NonNull
        public synchronized List<Element> getElements() {
            return this.zzbnx;
        }
    }

    public static class TextBlock
    extends TextBase {
        @GuardedBy(value="this")
        private final List<Line> zzbob;

        TextBlock(@NonNull com.google.android.gms.vision.text.TextBlock textBlock) {
            super((Text)textBlock);
            this.zzbob = new ArrayList<Line>();
            for (Text text : textBlock.getComponents()) {
                if (text instanceof com.google.android.gms.vision.text.Line) {
                    this.zzbob.add(new Line((com.google.android.gms.vision.text.Line)text));
                    continue;
                }
                Log.e((String)"FirebaseVisionText", (String)"A subcomponent of textblock is should be a line!");
            }
        }

        public TextBlock(@NonNull String string, @Nullable Rect rect, @NonNull List<RecognizedLanguage> list, @NonNull List<Line> list2, @Nullable Float f) {
            super(string, rect, list, f, null);
            this.zzbob = list2;
        }

        @NonNull
        public synchronized List<Line> getLines() {
            return this.zzbob;
        }
    }
}

