/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.config;

import com.google.firebase.perf.BuildConfig;
import com.google.firebase.perf.config.ConfigurationFlag;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class ConfigurationConstants {
    ConfigurationConstants() {
    }

    protected static final class TransportRolloutPercentage
    extends ConfigurationFlag<Float> {
        private static TransportRolloutPercentage instance;
        private static final float CCT_PERCENTAGE = 0.0f;
        private static final float FLG_PERCENTAGE = 100.0f;

        private TransportRolloutPercentage() {
        }

        public static synchronized TransportRolloutPercentage getInstance() {
            if (instance == null) {
                instance = new TransportRolloutPercentage();
            }
            return instance;
        }

        protected static float getCctPercentage() {
            return 0.0f;
        }

        protected static float getFlgPercentage() {
            return 100.0f;
        }

        @Override
        protected Float getDefault() {
            return Float.valueOf(0.0f);
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.TransportRolloutPercentage";
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_log_transport_android_percent";
        }
    }

    protected static final class LogSourceName
    extends ConfigurationFlag<String> {
        private static LogSourceName instance;
        private static final Map<Long, String> LOG_SOURCE_MAP;

        private LogSourceName() {
        }

        public static synchronized LogSourceName getInstance() {
            if (instance == null) {
                instance = new LogSourceName();
            }
            return instance;
        }

        protected static String getLogSourceName(long logSource) {
            return LOG_SOURCE_MAP.get(logSource);
        }

        protected static boolean isLogSourceKnown(long logSource) {
            return LOG_SOURCE_MAP.containsKey(logSource);
        }

        @Override
        protected String getDefault() {
            return BuildConfig.TRANSPORT_LOG_SRC;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_log_source";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.LogSourceName";
        }

        static {
            LOG_SOURCE_MAP = Collections.unmodifiableMap(new HashMap<Long, String>(){
                {
                    this.put(461L, "FIREPERF_AUTOPUSH");
                    this.put(462L, "FIREPERF");
                    this.put(675L, "FIREPERF_INTERNAL_LOW");
                    this.put(676L, "FIREPERF_INTERNAL_HIGH");
                }
            });
        }
    }

    protected static final class SessionsSamplingRate
    extends ConfigurationFlag<Float> {
        private static SessionsSamplingRate instance;

        private SessionsSamplingRate() {
        }

        public static synchronized SessionsSamplingRate getInstance() {
            if (instance == null) {
                instance = new SessionsSamplingRate();
            }
            return instance;
        }

        @Override
        protected Float getDefault() {
            return Float.valueOf(0.01f);
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionSamplingRate";
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_vc_session_sampling_rate";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_sampling_percentage";
        }
    }

    protected static final class RateLimitSec
    extends ConfigurationFlag<Long> {
        private static RateLimitSec instance;

        private RateLimitSec() {
        }

        public static synchronized RateLimitSec getInstance() {
            if (instance == null) {
                instance = new RateLimitSec();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 600L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_rl_time_limit_sec";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.TimeLimitSec";
        }
    }

    protected static final class NetworkEventCountBackground
    extends ConfigurationFlag<Long> {
        private static NetworkEventCountBackground instance;

        private NetworkEventCountBackground() {
        }

        public static synchronized NetworkEventCountBackground getInstance() {
            if (instance == null) {
                instance = new NetworkEventCountBackground();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 70L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_rl_network_event_count_bg";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.NetworkEventCountBackground";
        }
    }

    protected static final class NetworkEventCountForeground
    extends ConfigurationFlag<Long> {
        private static NetworkEventCountForeground instance;

        private NetworkEventCountForeground() {
        }

        public static synchronized NetworkEventCountForeground getInstance() {
            if (instance == null) {
                instance = new NetworkEventCountForeground();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 700L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_rl_network_event_count_fg";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.NetworkEventCountForeground";
        }
    }

    protected static final class TraceEventCountBackground
    extends ConfigurationFlag<Long> {
        private static TraceEventCountBackground instance;

        private TraceEventCountBackground() {
        }

        public static synchronized TraceEventCountBackground getInstance() {
            if (instance == null) {
                instance = new TraceEventCountBackground();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 30L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_rl_trace_event_count_bg";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.TraceEventCountBackground";
        }
    }

    protected static final class TraceEventCountForeground
    extends ConfigurationFlag<Long> {
        private static TraceEventCountForeground instance;

        private TraceEventCountForeground() {
        }

        public static synchronized TraceEventCountForeground getInstance() {
            if (instance == null) {
                instance = new TraceEventCountForeground();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 300L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_rl_trace_event_count_fg";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.TraceEventCountForeground";
        }
    }

    protected static final class SessionsMaxDurationMinutes
    extends ConfigurationFlag<Long> {
        private static SessionsMaxDurationMinutes instance;

        private SessionsMaxDurationMinutes() {
        }

        public static synchronized SessionsMaxDurationMinutes getInstance() {
            if (instance == null) {
                instance = new SessionsMaxDurationMinutes();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 240L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_session_max_duration_min";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_max_length_minutes";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionsMaxDurationMinutes";
        }
    }

    protected static final class SessionsMemoryCaptureFrequencyBackgroundMs
    extends ConfigurationFlag<Long> {
        private static SessionsMemoryCaptureFrequencyBackgroundMs instance;

        private SessionsMemoryCaptureFrequencyBackgroundMs() {
        }

        public static synchronized SessionsMemoryCaptureFrequencyBackgroundMs getInstance() {
            if (instance == null) {
                instance = new SessionsMemoryCaptureFrequencyBackgroundMs();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 0L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_session_gauge_memory_capture_frequency_bg_ms";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_memory_capture_frequency_bg_ms";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionsMemoryCaptureFrequencyBackgroundMs";
        }
    }

    protected static final class SessionsMemoryCaptureFrequencyForegroundMs
    extends ConfigurationFlag<Long> {
        private static SessionsMemoryCaptureFrequencyForegroundMs instance;

        private SessionsMemoryCaptureFrequencyForegroundMs() {
        }

        public static synchronized SessionsMemoryCaptureFrequencyForegroundMs getInstance() {
            if (instance == null) {
                instance = new SessionsMemoryCaptureFrequencyForegroundMs();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 100L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_session_gauge_memory_capture_frequency_fg_ms";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_memory_capture_frequency_fg_ms";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionsMemoryCaptureFrequencyForegroundMs";
        }
    }

    protected static final class SessionsCpuCaptureFrequencyBackgroundMs
    extends ConfigurationFlag<Long> {
        private static SessionsCpuCaptureFrequencyBackgroundMs instance;

        private SessionsCpuCaptureFrequencyBackgroundMs() {
        }

        public static synchronized SessionsCpuCaptureFrequencyBackgroundMs getInstance() {
            if (instance == null) {
                instance = new SessionsCpuCaptureFrequencyBackgroundMs();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 0L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_session_gauge_cpu_capture_frequency_bg_ms";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_cpu_capture_frequency_bg_ms";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionsCpuCaptureFrequencyBackgroundMs";
        }
    }

    protected static final class SessionsCpuCaptureFrequencyForegroundMs
    extends ConfigurationFlag<Long> {
        private static SessionsCpuCaptureFrequencyForegroundMs instance;

        private SessionsCpuCaptureFrequencyForegroundMs() {
        }

        public static synchronized SessionsCpuCaptureFrequencyForegroundMs getInstance() {
            if (instance == null) {
                instance = new SessionsCpuCaptureFrequencyForegroundMs();
            }
            return instance;
        }

        @Override
        protected Long getDefault() {
            return 100L;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_session_gauge_cpu_capture_frequency_fg_ms";
        }

        @Override
        protected String getMetadataFlag() {
            return "sessions_cpu_capture_frequency_fg_ms";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SessionsCpuCaptureFrequencyForegroundMs";
        }
    }

    protected static final class NetworkRequestSamplingRate
    extends ConfigurationFlag<Float> {
        private static NetworkRequestSamplingRate instance;

        private NetworkRequestSamplingRate() {
        }

        protected static synchronized NetworkRequestSamplingRate getInstance() {
            if (instance == null) {
                instance = new NetworkRequestSamplingRate();
            }
            return instance;
        }

        @Override
        protected Float getDefault() {
            return Float.valueOf(1.0f);
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_vc_network_request_sampling_rate";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.NetworkRequestSamplingRate";
        }
    }

    protected static final class TraceSamplingRate
    extends ConfigurationFlag<Float> {
        private static TraceSamplingRate instance;

        private TraceSamplingRate() {
        }

        protected static synchronized TraceSamplingRate getInstance() {
            if (instance == null) {
                instance = new TraceSamplingRate();
            }
            return instance;
        }

        @Override
        protected Float getDefault() {
            return Float.valueOf(1.0f);
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_vc_trace_sampling_rate";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.TraceSamplingRate";
        }
    }

    protected static final class SdkDisabledVersions
    extends ConfigurationFlag<String> {
        private static SdkDisabledVersions instance;

        protected SdkDisabledVersions() {
        }

        protected static synchronized SdkDisabledVersions getInstance() {
            if (instance == null) {
                instance = new SdkDisabledVersions();
            }
            return instance;
        }

        @Override
        protected String getDefault() {
            return "";
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_disabled_android_versions";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SdkDisabledVersions";
        }
    }

    protected static final class SdkEnabled
    extends ConfigurationFlag<Boolean> {
        private static SdkEnabled instance;

        protected SdkEnabled() {
        }

        protected static synchronized SdkEnabled getInstance() {
            if (instance == null) {
                instance = new SdkEnabled();
            }
            return instance;
        }

        @Override
        protected Boolean getDefault() {
            return true;
        }

        @Override
        protected String getRemoteConfigFlag() {
            return "fpr_enabled";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "com.google.firebase.perf.SdkEnabled";
        }
    }

    protected static final class CollectionEnabled
    extends ConfigurationFlag<Boolean> {
        private static CollectionEnabled instance;

        private CollectionEnabled() {
        }

        protected static synchronized CollectionEnabled getInstance() {
            if (instance == null) {
                instance = new CollectionEnabled();
            }
            return instance;
        }

        @Override
        protected Boolean getDefault() {
            return true;
        }

        @Override
        protected String getMetadataFlag() {
            return "firebase_performance_collection_enabled";
        }

        @Override
        protected String getDeviceCacheFlag() {
            return "isEnabled";
        }
    }

    protected static final class CollectionDeactivated
    extends ConfigurationFlag<Boolean> {
        private static CollectionDeactivated instance;

        private CollectionDeactivated() {
        }

        protected static synchronized CollectionDeactivated getInstance() {
            if (instance == null) {
                instance = new CollectionDeactivated();
            }
            return instance;
        }

        @Override
        protected Boolean getDefault() {
            return false;
        }

        @Override
        protected String getMetadataFlag() {
            return "firebase_performance_collection_deactivated";
        }
    }
}

