/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.config;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;

@VisibleForTesting(otherwise=3)
public class DeviceCacheManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static DeviceCacheManager instance;
    private static final String PREFS_NAME = "FirebasePerfSharedPrefs";
    private SharedPreferences sharedPref;

    private DeviceCacheManager() {
    }

    public static synchronized DeviceCacheManager getInstance() {
        if (instance == null) {
            instance = new DeviceCacheManager();
        }
        return instance;
    }

    @VisibleForTesting
    public static void clearInstance() {
        instance = null;
    }

    public synchronized void setContext(Context context) {
        if (this.sharedPref == null && context != null) {
            this.sharedPref = context.getSharedPreferences(PREFS_NAME, 0);
        }
    }

    public boolean containsKey(String key) {
        return this.sharedPref != null && key != null && this.sharedPref.contains(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        if (key == null) {
            logger.debug("Key is null when getting boolean value on device cache.", new Object[0]);
            return Optional.empty();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.empty();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.sharedPref.getBoolean(key, false));
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Key %s from sharedPreferences has type other than long: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public void clear(String key) {
        if (key == null) {
            logger.debug("Key is null. Cannot clear nullable key", new Object[0]);
            return;
        }
        this.sharedPref.edit().remove(key).apply();
    }

    public boolean setValue(String key, boolean value) {
        if (key == null) {
            logger.debug("Key is null when setting boolean value on device cache.", new Object[0]);
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putBoolean(key, value).apply();
        return true;
    }

    public Optional<String> getString(String key) {
        if (key == null) {
            logger.debug("Key is null when getting String value on device cache.", new Object[0]);
            return Optional.empty();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.empty();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.sharedPref.getString(key, ""));
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Key %s from sharedPreferences has type other than String: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public boolean setValue(String key, String value) {
        if (key == null) {
            logger.debug("Key is null when setting String value on device cache.", new Object[0]);
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        if (value == null) {
            this.sharedPref.edit().remove(key).apply();
            return true;
        }
        this.sharedPref.edit().putString(key, value).apply();
        return true;
    }

    public Optional<Float> getFloat(String key) {
        if (key == null) {
            logger.debug("Key is null when getting float value on device cache.", new Object[0]);
            return Optional.empty();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.empty();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Float.valueOf(this.sharedPref.getFloat(key, 0.0f)));
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Key %s from sharedPreferences has type other than float: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public boolean setValue(String key, float value) {
        if (key == null) {
            logger.debug("Key is null when setting float value on device cache.", new Object[0]);
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putFloat(key, value).apply();
        return true;
    }

    public Optional<Long> getLong(String key) {
        if (key == null) {
            logger.debug("Key is null when getting long value on device cache.", new Object[0]);
            return Optional.empty();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.empty();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.sharedPref.getLong(key, 0L));
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Key %s from sharedPreferences has type other than long: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public boolean setValue(String key, long value) {
        if (key == null) {
            logger.debug("Key is null when setting long value on device cache.", new Object[0]);
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putLong(key, value).apply();
        return true;
    }

    @Nullable
    private Context getFirebaseApplicationContext() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return FirebaseApp.getInstance().getApplicationContext();
    }
}

