/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.gauges;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.gauges.MemoryGaugeCollector$$Lambda$1;
import com.google.firebase.perf.gauges.MemoryGaugeCollector$$Lambda$4;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.StorageUnit;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.util.Utils;
import com.google.firebase.perf.v1.AndroidMemoryReading;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MemoryGaugeCollector {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    @SuppressLint(value={"StaticFieldLeak"})
    private static final MemoryGaugeCollector sharedInstance = new MemoryGaugeCollector();
    public static final long INVALID_MEMORY_COLLECTION_FREQUENCY = -1L;
    private static final int UNSET_MEMORY_METRIC_COLLECTION_RATE = -1;
    private final ScheduledExecutorService memoryMetricCollectorExecutor;
    public final ConcurrentLinkedQueue<AndroidMemoryReading> memoryMetricReadings;
    private final Runtime runtime;
    @Nullable
    private ScheduledFuture memoryMetricCollectorJob = null;
    private long memoryMetricCollectionRateMs = -1L;

    private MemoryGaugeCollector() {
        this(Executors.newSingleThreadScheduledExecutor(), Runtime.getRuntime());
    }

    @VisibleForTesting
    MemoryGaugeCollector(ScheduledExecutorService memoryMetricCollectorExecutor, Runtime runtime) {
        this.memoryMetricCollectorExecutor = memoryMetricCollectorExecutor;
        this.memoryMetricReadings = new ConcurrentLinkedQueue();
        this.runtime = runtime;
    }

    public static MemoryGaugeCollector getInstance() {
        return sharedInstance;
    }

    public void startCollecting(long memoryMetricCollectionRateMs, Timer referenceTime) {
        if (MemoryGaugeCollector.isInvalidCollectionFrequency(memoryMetricCollectionRateMs)) {
            return;
        }
        if (this.memoryMetricCollectorJob != null) {
            if (this.memoryMetricCollectionRateMs != memoryMetricCollectionRateMs) {
                this.stopCollecting();
                this.scheduleMemoryMetricCollectionWithRate(memoryMetricCollectionRateMs, referenceTime);
            }
            return;
        }
        this.scheduleMemoryMetricCollectionWithRate(memoryMetricCollectionRateMs, referenceTime);
    }

    public void stopCollecting() {
        if (this.memoryMetricCollectorJob == null) {
            return;
        }
        this.memoryMetricCollectorJob.cancel(false);
        this.memoryMetricCollectorJob = null;
        this.memoryMetricCollectionRateMs = -1L;
    }

    public void collectOnce(Timer referenceTime) {
        this.scheduleMemoryMetricCollectionOnce(referenceTime);
    }

    private synchronized void scheduleMemoryMetricCollectionWithRate(long memoryMetricCollectionRate, Timer referenceTime) {
        this.memoryMetricCollectionRateMs = memoryMetricCollectionRate;
        try {
            this.memoryMetricCollectorJob = this.memoryMetricCollectorExecutor.scheduleAtFixedRate(MemoryGaugeCollector$$Lambda$1.lambdaFactory$(this, referenceTime), 0L, memoryMetricCollectionRate, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Unable to start collecting Memory Metrics: " + e.getMessage(), new Object[0]);
        }
    }

    private synchronized void scheduleMemoryMetricCollectionOnce(Timer referenceTime) {
        try {
            ScheduledFuture<?> scheduledFuture = this.memoryMetricCollectorExecutor.schedule(MemoryGaugeCollector$$Lambda$4.lambdaFactory$(this, referenceTime), 0L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Unable to collect Memory Metric: " + e.getMessage(), new Object[0]);
        }
    }

    @Nullable
    private AndroidMemoryReading syncCollectMemoryMetric(Timer referenceTime) {
        if (referenceTime == null) {
            return null;
        }
        long memoryMetricTimestampUs = referenceTime.getCurrentTimestampMicros();
        return (AndroidMemoryReading)AndroidMemoryReading.newBuilder().setClientTimeUs(memoryMetricTimestampUs).setUsedAppJavaHeapMemoryKb(this.getCurrentUsedAppJavaHeapMemoryKb()).build();
    }

    private int getCurrentUsedAppJavaHeapMemoryKb() {
        return Utils.saturatedIntCast(StorageUnit.BYTES.toKilobytes(this.runtime.totalMemory() - this.runtime.freeMemory()));
    }

    public static boolean isInvalidCollectionFrequency(long collectionFrequency) {
        return collectionFrequency <= 0L;
    }

    static /* synthetic */ void lambda$scheduleMemoryMetricCollectionOnce$1(MemoryGaugeCollector this_, Timer referenceTime) {
        AndroidMemoryReading memoryReading = this_.syncCollectMemoryMetric(referenceTime);
        if (memoryReading != null) {
            this_.memoryMetricReadings.add(memoryReading);
        }
    }

    static /* synthetic */ void lambda$scheduleMemoryMetricCollectionWithRate$0(MemoryGaugeCollector this_, Timer referenceTime) {
        AndroidMemoryReading memoryReading = this_.syncCollectMemoryMetric(referenceTime);
        if (memoryReading != null) {
            this_.memoryMetricReadings.add(memoryReading);
        }
    }
}

