/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.StorageUnit;
import com.google.firebase.perf.util.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GaugeMetadataManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final Runtime runtime;
    private final ActivityManager activityManager;
    private final ActivityManager.MemoryInfo memoryInfo;
    private final String currentProcessName;
    private final Context applicationContext;

    GaugeMetadataManager(Context applicationContext) {
        this(Runtime.getRuntime(), applicationContext);
    }

    @VisibleForTesting
    GaugeMetadataManager(Runtime runtime, Context applicationContext) {
        this.runtime = runtime;
        this.applicationContext = applicationContext;
        this.activityManager = (ActivityManager)applicationContext.getSystemService("activity");
        this.memoryInfo = new ActivityManager.MemoryInfo();
        this.activityManager.getMemoryInfo(this.memoryInfo);
        this.currentProcessName = this.getCurrentProcessName();
    }

    public String getProcessName() {
        return this.currentProcessName;
    }

    public int getMaxAppJavaHeapMemoryKb() {
        return Utils.saturatedIntCast(StorageUnit.BYTES.toKilobytes(this.runtime.maxMemory()));
    }

    public int getMaxEncouragedAppJavaHeapMemoryKb() {
        return Utils.saturatedIntCast(StorageUnit.MEGABYTES.toKilobytes(this.activityManager.getMemoryClass()));
    }

    public int getDeviceRamSizeKb() {
        if (Build.VERSION.SDK_INT >= 16) {
            return Utils.saturatedIntCast(StorageUnit.BYTES.toKilobytes(this.memoryInfo.totalMem));
        }
        return this.readTotalRAM("/proc/meminfo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int readTotalRAM(String procFileName) {
        try {
            int n;
            String s;
            BufferedReader br = new BufferedReader(new FileReader(procFileName));
            try {
                s = br.readLine();
                while (s != null) {
                    if (!s.startsWith("MemTotal")) break block9;
                    Matcher m = Pattern.compile("\\d+").matcher(s);
                    n = m.find() ? Integer.parseInt(m.group()) : 0;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            {
                block9: {
                    br.close();
                    return n;
                }
                s = br.readLine();
                continue;
            }
            br.close();
            return 0;
        }
        catch (IOException ioe) {
            logger.warn("Unable to read '" + procFileName + "' file: " + ioe.getMessage(), new Object[0]);
            return 0;
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unable to parse '" + procFileName + "' file: " + nfe.getMessage(), new Object[0]);
        }
        return 0;
    }

    private String getCurrentProcessName() {
        int myProcessPid = Process.myPid();
        List runningAppProcessInfos = this.activityManager.getRunningAppProcesses();
        if (runningAppProcessInfos != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppProcessInfos) {
                if (processInfo.pid != myProcessPid) continue;
                return processInfo.processName;
            }
        }
        return this.applicationContext.getPackageName();
    }
}

