/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import androidx.annotation.NonNull;
import com.google.firebase.perf.metrics.Counter;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.v1.PerfSession;
import com.google.firebase.perf.v1.TraceMetric;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class TraceMetricBuilder {
    private final Trace mTrace;

    TraceMetricBuilder(@NonNull Trace trace) {
        this.mTrace = trace;
    }

    TraceMetric build() {
        TraceMetric.Builder traceMetric = TraceMetric.newBuilder().setName(this.mTrace.getName()).setClientStartTimeUs(this.mTrace.getStartTime().getMicros()).setDurationUs(this.mTrace.getStartTime().getDurationMicros(this.mTrace.getEndTime()));
        Map<String, Counter> traceCounters = this.mTrace.getCounters();
        for (Counter counter : traceCounters.values()) {
            traceMetric.putCounters(counter.getName(), counter.getCount());
        }
        List<Trace> subTraces = this.mTrace.getSubtraces();
        if (!subTraces.isEmpty()) {
            for (Trace subtrace : subTraces) {
                traceMetric.addSubtraces(new TraceMetricBuilder(subtrace).build());
            }
        }
        traceMetric.putAllCustomAttributes(this.mTrace.getAttributes());
        PerfSession[] perfSessionArray = com.google.firebase.perf.internal.PerfSession.buildAndSort(this.mTrace.getSessions());
        if (perfSessionArray != null) {
            traceMetric.addAllPerfSessions(Arrays.asList(perfSessionArray));
        }
        return (TraceMetric)traceMetric.build();
    }
}

