/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import android.os.Build;
import com.google.firebase.perf.impl.NetworkRequestMetricBuilder;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.network.InstrHttpInputStream;
import com.google.firebase.perf.network.InstrHttpOutputStream;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;

class InstrURLConnectionBase {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String USER_AGENT_PROPERTY = "User-Agent";
    private final HttpURLConnection mHttpUrlConnection;
    private final NetworkRequestMetricBuilder mBuilder;
    private long mTimeRequested = -1L;
    private long mTimeToResponseInitiated = -1L;
    private final Timer mTimer;

    public InstrURLConnectionBase(HttpURLConnection connection, Timer timer, NetworkRequestMetricBuilder builder) {
        this.mHttpUrlConnection = connection;
        this.mBuilder = builder;
        this.mTimer = timer;
        this.mBuilder.setUrl(this.mHttpUrlConnection.getURL().toString());
    }

    public void connect() throws IOException {
        if (this.mTimeRequested == -1L) {
            this.mTimer.reset();
            this.mTimeRequested = this.mTimer.getMicros();
            this.mBuilder.setRequestStartTimeMicros(this.mTimeRequested);
        }
        try {
            this.mHttpUrlConnection.connect();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public void disconnect() {
        this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
        this.mBuilder.build();
        this.mHttpUrlConnection.disconnect();
    }

    public Object getContent() throws IOException {
        Object content;
        this.updateRequestInfo();
        this.mBuilder.setHttpResponseCode(this.mHttpUrlConnection.getResponseCode());
        try {
            content = this.mHttpUrlConnection.getContent();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
        if (content instanceof InputStream) {
            this.mBuilder.setResponseContentType(this.mHttpUrlConnection.getContentType());
            content = new InstrHttpInputStream((InputStream)content, this.mBuilder, this.mTimer);
        } else {
            this.mBuilder.setResponseContentType(this.mHttpUrlConnection.getContentType());
            this.mBuilder.setResponsePayloadBytes(this.mHttpUrlConnection.getContentLength());
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            this.mBuilder.build();
        }
        return content;
    }

    public Object getContent(Class[] classes) throws IOException {
        Object content;
        this.updateRequestInfo();
        this.mBuilder.setHttpResponseCode(this.mHttpUrlConnection.getResponseCode());
        try {
            content = this.mHttpUrlConnection.getContent(classes);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
        if (content instanceof InputStream) {
            this.mBuilder.setResponseContentType(this.mHttpUrlConnection.getContentType());
            content = new InstrHttpInputStream((InputStream)content, this.mBuilder, this.mTimer);
        } else {
            this.mBuilder.setResponseContentType(this.mHttpUrlConnection.getContentType());
            this.mBuilder.setResponsePayloadBytes(this.mHttpUrlConnection.getContentLength());
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            this.mBuilder.build();
        }
        return content;
    }

    public InputStream getInputStream() throws IOException {
        this.updateRequestInfo();
        this.mBuilder.setHttpResponseCode(this.mHttpUrlConnection.getResponseCode());
        this.mBuilder.setResponseContentType(this.mHttpUrlConnection.getContentType());
        try {
            InputStream inputStream = this.mHttpUrlConnection.getInputStream();
            return new InstrHttpInputStream(inputStream, this.mBuilder, this.mTimer);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public long getLastModified() {
        this.updateRequestInfo();
        long value = this.mHttpUrlConnection.getLastModified();
        return value;
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return new InstrHttpOutputStream(this.mHttpUrlConnection.getOutputStream(), this.mBuilder, this.mTimer);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public Permission getPermission() throws IOException {
        try {
            return this.mHttpUrlConnection.getPermission();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public int getResponseCode() throws IOException {
        this.updateRequestInfo();
        if (this.mTimeToResponseInitiated == -1L) {
            this.mTimeToResponseInitiated = this.mTimer.getDurationMicros();
            this.mBuilder.setTimeToResponseInitiatedMicros(this.mTimeToResponseInitiated);
        }
        try {
            int code = this.mHttpUrlConnection.getResponseCode();
            this.mBuilder.setHttpResponseCode(code);
            return code;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public String getResponseMessage() throws IOException {
        this.updateRequestInfo();
        if (this.mTimeToResponseInitiated == -1L) {
            this.mTimeToResponseInitiated = this.mTimer.getDurationMicros();
            this.mBuilder.setTimeToResponseInitiatedMicros(this.mTimeToResponseInitiated);
        }
        try {
            String message = this.mHttpUrlConnection.getResponseMessage();
            this.mBuilder.setHttpResponseCode(this.mHttpUrlConnection.getResponseCode());
            return message;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    public long getExpiration() {
        this.updateRequestInfo();
        long exp = this.mHttpUrlConnection.getExpiration();
        return exp;
    }

    public String getHeaderField(int n) {
        this.updateRequestInfo();
        String value = this.mHttpUrlConnection.getHeaderField(n);
        return value;
    }

    public String getHeaderField(String name) {
        this.updateRequestInfo();
        String value = this.mHttpUrlConnection.getHeaderField(name);
        return value;
    }

    public long getHeaderFieldDate(String name, long defaultDate) {
        this.updateRequestInfo();
        long value = this.mHttpUrlConnection.getHeaderFieldDate(name, defaultDate);
        return value;
    }

    public int getHeaderFieldInt(String name, int defaultInt) {
        this.updateRequestInfo();
        int value = this.mHttpUrlConnection.getHeaderFieldInt(name, defaultInt);
        return value;
    }

    public long getHeaderFieldLong(String name, long defaultLong) {
        this.updateRequestInfo();
        long value = 0L;
        if (Build.VERSION.SDK_INT >= 24) {
            value = this.mHttpUrlConnection.getHeaderFieldLong(name, defaultLong);
        }
        return value;
    }

    public String getHeaderFieldKey(int n) {
        this.updateRequestInfo();
        String value = this.mHttpUrlConnection.getHeaderFieldKey(n);
        return value;
    }

    public Map<String, List<String>> getHeaderFields() {
        this.updateRequestInfo();
        Map<String, List<String>> value = this.mHttpUrlConnection.getHeaderFields();
        return value;
    }

    public String getContentEncoding() {
        this.updateRequestInfo();
        return this.mHttpUrlConnection.getContentEncoding();
    }

    public int getContentLength() {
        this.updateRequestInfo();
        return this.mHttpUrlConnection.getContentLength();
    }

    public long getContentLengthLong() {
        this.updateRequestInfo();
        long contentLength = 0L;
        if (Build.VERSION.SDK_INT >= 24) {
            contentLength = this.mHttpUrlConnection.getContentLengthLong();
        }
        return contentLength;
    }

    public String getContentType() {
        this.updateRequestInfo();
        return this.mHttpUrlConnection.getContentType();
    }

    public long getDate() {
        this.updateRequestInfo();
        return this.mHttpUrlConnection.getDate();
    }

    public void addRequestProperty(String key, String value) {
        this.mHttpUrlConnection.addRequestProperty(key, value);
    }

    public boolean equals(Object obj) {
        return this.mHttpUrlConnection.equals(obj);
    }

    public boolean getAllowUserInteraction() {
        return this.mHttpUrlConnection.getAllowUserInteraction();
    }

    public int getConnectTimeout() {
        return this.mHttpUrlConnection.getConnectTimeout();
    }

    public boolean getDefaultUseCaches() {
        return this.mHttpUrlConnection.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.mHttpUrlConnection.getDoInput();
    }

    public boolean getDoOutput() {
        return this.mHttpUrlConnection.getDoOutput();
    }

    public InputStream getErrorStream() {
        this.updateRequestInfo();
        try {
            this.mBuilder.setHttpResponseCode(this.mHttpUrlConnection.getResponseCode());
        }
        catch (IOException e) {
            logger.debug("IOException thrown trying to obtain the response code", new Object[0]);
        }
        InputStream errorStream = this.mHttpUrlConnection.getErrorStream();
        if (errorStream != null) {
            return new InstrHttpInputStream(errorStream, this.mBuilder, this.mTimer);
        }
        return errorStream;
    }

    public long getIfModifiedSince() {
        return this.mHttpUrlConnection.getIfModifiedSince();
    }

    public boolean getInstanceFollowRedirects() {
        return this.mHttpUrlConnection.getInstanceFollowRedirects();
    }

    public int getReadTimeout() {
        return this.mHttpUrlConnection.getReadTimeout();
    }

    public String getRequestMethod() {
        return this.mHttpUrlConnection.getRequestMethod();
    }

    public Map<String, List<String>> getRequestProperties() {
        return this.mHttpUrlConnection.getRequestProperties();
    }

    public String getRequestProperty(String key) {
        return this.mHttpUrlConnection.getRequestProperty(key);
    }

    public URL getURL() {
        return this.mHttpUrlConnection.getURL();
    }

    public boolean getUseCaches() {
        return this.mHttpUrlConnection.getUseCaches();
    }

    public int hashCode() {
        return this.mHttpUrlConnection.hashCode();
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.mHttpUrlConnection.setAllowUserInteraction(allowuserinteraction);
    }

    public void setChunkedStreamingMode(int chunklen) {
        this.mHttpUrlConnection.setChunkedStreamingMode(chunklen);
    }

    public void setConnectTimeout(int timeout) {
        this.mHttpUrlConnection.setConnectTimeout(timeout);
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.mHttpUrlConnection.setDefaultUseCaches(defaultusecaches);
    }

    public void setDoInput(boolean doinput) {
        this.mHttpUrlConnection.setDoInput(doinput);
    }

    public void setDoOutput(boolean dooutput) {
        this.mHttpUrlConnection.setDoOutput(dooutput);
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        this.mHttpUrlConnection.setFixedLengthStreamingMode(contentLength);
    }

    public void setFixedLengthStreamingMode(long contentLength) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mHttpUrlConnection.setFixedLengthStreamingMode(contentLength);
        }
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        this.mHttpUrlConnection.setIfModifiedSince(ifmodifiedsince);
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.mHttpUrlConnection.setInstanceFollowRedirects(followRedirects);
    }

    public void setReadTimeout(int timeout) {
        this.mHttpUrlConnection.setReadTimeout(timeout);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.mHttpUrlConnection.setRequestMethod(method);
    }

    public void setRequestProperty(String key, String value) {
        if (USER_AGENT_PROPERTY.equalsIgnoreCase(key)) {
            this.mBuilder.setUserAgent(value);
        }
        this.mHttpUrlConnection.setRequestProperty(key, value);
    }

    public void setUseCaches(boolean usecaches) {
        this.mHttpUrlConnection.setUseCaches(usecaches);
    }

    public String toString() {
        return this.mHttpUrlConnection.toString();
    }

    public boolean usingProxy() {
        return this.mHttpUrlConnection.usingProxy();
    }

    private void updateRequestInfo() {
        String method;
        if (this.mTimeRequested == -1L) {
            this.mTimer.reset();
            this.mTimeRequested = this.mTimer.getMicros();
            this.mBuilder.setRequestStartTimeMicros(this.mTimeRequested);
        }
        if ((method = this.getRequestMethod()) != null) {
            this.mBuilder.setHttpMethod(method);
        } else if (this.getDoOutput()) {
            this.mBuilder.setHttpMethod("POST");
        } else {
            this.mBuilder.setHttpMethod("GET");
        }
    }
}

