/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.impl.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class InstrumentApacheHttpResponseHandler<T>
implements ResponseHandler<T> {
    private final ResponseHandler<? extends T> mResponseHandlerDelegate;
    private final Timer mTimer;
    private final NetworkRequestMetricBuilder mBuilder;

    public InstrumentApacheHttpResponseHandler(ResponseHandler<? extends T> responseHandler, Timer timer, NetworkRequestMetricBuilder builder) {
        this.mResponseHandlerDelegate = responseHandler;
        this.mTimer = timer;
        this.mBuilder = builder;
    }

    public T handleResponse(HttpResponse httpResponse) throws IOException {
        String contentType;
        this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
        this.mBuilder.setHttpResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)httpResponse);
        if (responseContentLength != null) {
            this.mBuilder.setResponsePayloadBytes(responseContentLength);
        }
        if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(httpResponse)) != null) {
            this.mBuilder.setResponseContentType(contentType);
        }
        this.mBuilder.build();
        return (T)this.mResponseHandlerDelegate.handleResponse(httpResponse);
    }
}

