/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.impl.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.FirebasePerfOkHttpClient;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class InstrumentOkHttpEnqueueCallback
implements Callback {
    private final Callback mCallback;
    private final NetworkRequestMetricBuilder mBuilder;
    private final long mStartTimeMicros;
    private final Timer mTimer;

    public InstrumentOkHttpEnqueueCallback(Callback callback, TransportManager transportManager, Timer timer, long startTime) {
        this.mCallback = callback;
        this.mBuilder = NetworkRequestMetricBuilder.builder(transportManager);
        this.mStartTimeMicros = startTime;
        this.mTimer = timer;
    }

    public void onFailure(Call call, IOException e) {
        Request request = call.request();
        if (request != null) {
            String method;
            HttpUrl url = request.url();
            if (url != null) {
                this.mBuilder.setUrl(url.url().toString());
            }
            if ((method = request.method()) != null) {
                this.mBuilder.setHttpMethod(request.method());
            }
        }
        this.mBuilder.setRequestStartTimeMicros(this.mStartTimeMicros);
        this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
        NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
        this.mCallback.onFailure(call, e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        long responseCompletedTimeMicros = this.mTimer.getDurationMicros();
        FirebasePerfOkHttpClient.sendNetworkMetric(response, this.mBuilder, this.mStartTimeMicros, responseCompletedTimeMicros);
        this.mCallback.onResponse(call, response);
    }
}

