/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.transport;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.perf.BuildConfig;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.internal.AppStateMonitor;
import com.google.firebase.perf.internal.PerfMetricValidator;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.transport.CctTransport;
import com.google.firebase.perf.transport.FlgTransport;
import com.google.firebase.perf.transport.PendingPerfEvent;
import com.google.firebase.perf.transport.RateLimiter;
import com.google.firebase.perf.transport.TransportManager$$Lambda$1;
import com.google.firebase.perf.transport.TransportManager$$Lambda$2;
import com.google.firebase.perf.transport.TransportManager$$Lambda$3;
import com.google.firebase.perf.transport.TransportManager$$Lambda$4;
import com.google.firebase.perf.transport.TransportManager$$Lambda$5;
import com.google.firebase.perf.transport.TransportManager$$Lambda$6;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.v1.AndroidApplicationInfo;
import com.google.firebase.perf.v1.ApplicationInfo;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.GaugeMetric;
import com.google.firebase.perf.v1.NetworkRequestMetric;
import com.google.firebase.perf.v1.PerfMetric;
import com.google.firebase.perf.v1.PerfMetricOrBuilder;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransportManager
implements AppStateMonitor.AppStateCallback {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final TransportManager instance = new TransportManager();
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 1;
    private FirebaseApp firebaseApp;
    @Nullable
    private FirebasePerformance firebasePerformance;
    private FirebaseInstallationsApi firebaseInstallationsApi;
    private Provider<TransportFactory> flgTransportFactoryProvider;
    private CctTransport cctTransport;
    private FlgTransport flgTransport;
    private ExecutorService executorService;
    private final ApplicationInfo.Builder applicationInfoBuilder;
    private Context appContext;
    private ConfigResolver configResolver;
    private RateLimiter rateLimiter;
    private AppStateMonitor appStateMonitor;
    private final AtomicBoolean isTransportInitialized = new AtomicBoolean(false);
    private boolean isForegroundState = false;
    private final Map<String, Integer> cacheMap;
    private static final String KEY_AVAILABLE_TRACES_FOR_CACHING = "KEY_AVAILABLE_TRACES_FOR_CACHING";
    private static final String KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING = "KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING";
    private static final String KEY_AVAILABLE_GAUGES_FOR_CACHING = "KEY_AVAILABLE_GAUGES_FOR_CACHING";
    private static final int MAX_TRACE_METRICS_CACHE_SIZE = 50;
    private static final int MAX_NETWORK_REQUEST_METRICS_CACHE_SIZE = 50;
    private static final int MAX_GAUGE_METRICS_CACHE_SIZE = 50;
    private final ConcurrentLinkedQueue<PendingPerfEvent> pendingEventsQueue = new ConcurrentLinkedQueue();

    private TransportManager() {
        this.executorService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.applicationInfoBuilder = ApplicationInfo.newBuilder();
        this.cacheMap = new ConcurrentHashMap<String, Integer>();
        this.cacheMap.put(KEY_AVAILABLE_TRACES_FOR_CACHING, 50);
        this.cacheMap.put(KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING, 50);
        this.cacheMap.put(KEY_AVAILABLE_GAUGES_FOR_CACHING, 50);
    }

    public static TransportManager getInstance() {
        return instance;
    }

    @VisibleForTesting(otherwise=5)
    void initializeForTest(FirebaseApp firebaseApp, FirebasePerformance firebasePerformance, FirebaseInstallationsApi firebaseInstallationsApi, Provider<TransportFactory> flgTransportFactoryProvider, ConfigResolver configResolver, RateLimiter rateLimiter, AppStateMonitor appStateMonitor, CctTransport cctTransport, FlgTransport flgTransport, ExecutorService executorService) {
        this.firebaseApp = firebaseApp;
        this.appContext = firebaseApp.getApplicationContext();
        this.firebasePerformance = firebasePerformance;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.flgTransportFactoryProvider = flgTransportFactoryProvider;
        this.configResolver = configResolver;
        this.rateLimiter = rateLimiter;
        this.appStateMonitor = appStateMonitor;
        this.cctTransport = cctTransport;
        this.flgTransport = flgTransport;
        this.executorService = executorService;
        this.cacheMap.put(KEY_AVAILABLE_TRACES_FOR_CACHING, 50);
        this.cacheMap.put(KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING, 50);
        this.cacheMap.put(KEY_AVAILABLE_GAUGES_FOR_CACHING, 50);
        this.finishInitialization();
    }

    public void initialize(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseInstallationsApi firebaseInstallationsApi, @NonNull Provider<TransportFactory> flgTransportFactoryProvider) {
        this.firebaseApp = firebaseApp;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.flgTransportFactoryProvider = flgTransportFactoryProvider;
        this.executorService.execute(TransportManager$$Lambda$1.lambdaFactory$(this));
    }

    @WorkerThread
    private void syncInit() {
        this.appContext = this.firebaseApp.getApplicationContext();
        this.configResolver = ConfigResolver.getInstance();
        this.rateLimiter = new RateLimiter(this.appContext, 100.0, 500L);
        this.appStateMonitor = AppStateMonitor.getInstance();
        this.cctTransport = new CctTransport(this.appContext, this.configResolver.getAndCacheLogSourceName());
        this.flgTransport = new FlgTransport(this.flgTransportFactoryProvider, this.configResolver.getAndCacheLogSourceName());
        this.finishInitialization();
    }

    private void finishInitialization() {
        this.appStateMonitor.registerForAppState(new WeakReference<AppStateMonitor.AppStateCallback>(instance));
        this.applicationInfoBuilder.setGoogleAppId(this.firebaseApp.getOptions().getApplicationId()).setAndroidAppInfo(AndroidApplicationInfo.newBuilder().setPackageName(this.appContext.getPackageName()).setSdkVersion(BuildConfig.FIREPERF_VERSION_NAME).setVersionName(TransportManager.getVersionName(this.appContext)));
        this.isTransportInitialized.set(true);
        while (!this.pendingEventsQueue.isEmpty()) {
            PendingPerfEvent pendingPerfEvent = this.pendingEventsQueue.poll();
            if (pendingPerfEvent == null) continue;
            this.executorService.execute(TransportManager$$Lambda$2.lambdaFactory$(this, pendingPerfEvent));
        }
    }

    @Override
    public void onUpdateAppState(ApplicationProcessState newAppState) {
        boolean bl = this.isForegroundState = newAppState == ApplicationProcessState.FOREGROUND;
        if (this.isInitialized()) {
            this.executorService.execute(TransportManager$$Lambda$3.lambdaFactory$(this));
        }
    }

    public boolean isInitialized() {
        return this.isTransportInitialized.get();
    }

    public void log(TraceMetric traceMetric) {
        this.log(traceMetric, ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN);
    }

    public void log(TraceMetric traceMetric, ApplicationProcessState appState) {
        this.executorService.execute(TransportManager$$Lambda$4.lambdaFactory$(this, traceMetric, appState));
    }

    public void log(NetworkRequestMetric networkRequestMetric) {
        this.log(networkRequestMetric, ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN);
    }

    public void log(NetworkRequestMetric networkRequestMetric, ApplicationProcessState appState) {
        this.executorService.execute(TransportManager$$Lambda$5.lambdaFactory$(this, networkRequestMetric, appState));
    }

    public void log(GaugeMetric gaugeMetric) {
        this.log(gaugeMetric, ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN);
    }

    public void log(GaugeMetric gaugeMetric, ApplicationProcessState appState) {
        this.executorService.execute(TransportManager$$Lambda$6.lambdaFactory$(this, gaugeMetric, appState));
    }

    @WorkerThread
    private void syncLog(PerfMetric.Builder perfMetricBuilder, ApplicationProcessState appState) {
        if (!this.isInitialized()) {
            if (this.isAllowedToCache(perfMetricBuilder)) {
                logger.debug("Transport is not initialized yet, %s will be queued for to be dispatched later", TransportManager.getLogcatMsg(perfMetricBuilder));
                this.pendingEventsQueue.add(new PendingPerfEvent(perfMetricBuilder, appState));
            }
            return;
        }
        PerfMetric perfMetric = this.setApplicationInfoAndBuild(perfMetricBuilder, appState);
        if (this.isAllowedToDispatch(perfMetric)) {
            this.dispatchLog(perfMetric);
            SessionManager.getInstance().updatePerfSessionIfExpired();
        }
    }

    @WorkerThread
    private boolean isAllowedToCache(PerfMetricOrBuilder perfMetricOrBuilder) {
        int availableTracesForCaching = this.cacheMap.get(KEY_AVAILABLE_TRACES_FOR_CACHING);
        int availableNetworkRequestsForCaching = this.cacheMap.get(KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING);
        int availableGaugesForCaching = this.cacheMap.get(KEY_AVAILABLE_GAUGES_FOR_CACHING);
        if (perfMetricOrBuilder.hasTraceMetric() && availableTracesForCaching > 0) {
            this.cacheMap.put(KEY_AVAILABLE_TRACES_FOR_CACHING, availableTracesForCaching - 1);
            return true;
        }
        if (perfMetricOrBuilder.hasNetworkRequestMetric() && availableNetworkRequestsForCaching > 0) {
            this.cacheMap.put(KEY_AVAILABLE_NETWORK_REQUESTS_FOR_CACHING, availableNetworkRequestsForCaching - 1);
            return true;
        }
        if (perfMetricOrBuilder.hasGaugeMetric() && availableGaugesForCaching > 0) {
            this.cacheMap.put(KEY_AVAILABLE_GAUGES_FOR_CACHING, availableGaugesForCaching - 1);
            return true;
        }
        logger.debug("%s is not allowed to cache. Cache exhausted the limit (availableTracesForCaching: %d, availableNetworkRequestsForCaching: %d, availableGaugesForCaching: %d).", TransportManager.getLogcatMsg(perfMetricOrBuilder), availableTracesForCaching, availableNetworkRequestsForCaching, availableGaugesForCaching);
        return false;
    }

    @WorkerThread
    private boolean isAllowedToDispatch(PerfMetric perfMetric) {
        if (!this.configResolver.isPerformanceMonitoringEnabled()) {
            logger.info("Performance collection is not enabled, dropping %s", TransportManager.getLogcatMsg(perfMetric));
            return false;
        }
        if (!perfMetric.getApplicationInfo().hasAppInstanceId()) {
            logger.warn("App Instance ID is null or empty, dropping %s", TransportManager.getLogcatMsg(perfMetric));
            return false;
        }
        if (!PerfMetricValidator.isValid(perfMetric, this.appContext)) {
            logger.warn("Unable to process the PerfMetric (%s) due to missing or invalid values. See earlier log statements for additional information on the specific missing/invalid values.", TransportManager.getLogcatMsg(perfMetric));
            return false;
        }
        if (!this.rateLimiter.check(perfMetric)) {
            this.incrementDropCount(perfMetric);
            if (perfMetric.hasTraceMetric()) {
                logger.info("Rate Limited - %s", TransportManager.getLogcatMsg(perfMetric.getTraceMetric()));
            } else if (perfMetric.hasNetworkRequestMetric()) {
                logger.info("Rate Limited - %s", TransportManager.getLogcatMsg(perfMetric.getNetworkRequestMetric()));
            }
            return false;
        }
        return true;
    }

    @WorkerThread
    private void dispatchLog(PerfMetric perfMetric) {
        logger.info("Logging %s", TransportManager.getLogcatMsg(perfMetric));
        if (this.configResolver.isDispatchToFlg(perfMetric.getApplicationInfo().getAppInstanceId())) {
            this.flgTransport.log(perfMetric);
        } else {
            this.cctTransport.log(perfMetric);
        }
    }

    private static String getVersionName(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionName == null ? "" : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }

    private PerfMetric setApplicationInfoAndBuild(PerfMetric.Builder perfMetricBuilder, ApplicationProcessState appState) {
        this.updateFirebaseInstallationIdIfPossibleAndNeeded();
        ApplicationInfo.Builder appInfoBuilder = this.applicationInfoBuilder.setApplicationProcessState(appState);
        if (perfMetricBuilder.hasTraceMetric()) {
            appInfoBuilder = ((ApplicationInfo.Builder)appInfoBuilder.clone()).putAllCustomAttributes(this.getGlobalCustomAttributes());
        }
        return (PerfMetric)perfMetricBuilder.setApplicationInfo(appInfoBuilder).build();
    }

    private Map<String, String> getGlobalCustomAttributes() {
        this.updateFirebasePerformanceIfPossibleAndNeeded();
        return this.firebasePerformance != null ? this.firebasePerformance.getAttributes() : Collections.emptyMap();
    }

    private void updateFirebasePerformanceIfPossibleAndNeeded() {
        if (this.firebasePerformance == null && this.isInitialized()) {
            this.firebasePerformance = FirebasePerformance.getInstance();
        }
    }

    @WorkerThread
    private void updateFirebaseInstallationIdIfPossibleAndNeeded() {
        if (this.configResolver.isPerformanceMonitoringEnabled()) {
            if (this.applicationInfoBuilder.hasAppInstanceId() && !this.isForegroundState) {
                return;
            }
            String installationId = null;
            try {
                installationId = (String)Tasks.await((Task)this.firebaseInstallationsApi.getId(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                logger.error("Unable to retrieve Installation Id: %s", e.getMessage());
            }
            catch (InterruptedException e) {
                logger.error("Task to retrieve Installation Id is interrupted: %s", e.getMessage());
            }
            catch (TimeoutException e) {
                logger.error("Task to retrieve Installation Id is timed out: %s", e.getMessage());
            }
            if (!TextUtils.isEmpty((CharSequence)installationId)) {
                this.applicationInfoBuilder.setAppInstanceId(installationId);
            } else {
                logger.warn("Firebase Installation Id is empty, contact Firebase Support for debugging.", new Object[0]);
            }
        }
    }

    private void incrementDropCount(PerfMetric metric) {
        if (metric.hasTraceMetric()) {
            this.appStateMonitor.incrementCount(Constants.CounterNames.TRACE_EVENT_RATE_LIMITED.toString(), 1L);
        } else if (metric.hasNetworkRequestMetric()) {
            this.appStateMonitor.incrementCount(Constants.CounterNames.NETWORK_TRACE_EVENT_RATE_LIMITED.toString(), 1L);
        }
    }

    private static String getLogcatMsg(PerfMetricOrBuilder perfMetric) {
        if (perfMetric.hasTraceMetric()) {
            return TransportManager.getLogcatMsg(perfMetric.getTraceMetric());
        }
        if (perfMetric.hasNetworkRequestMetric()) {
            return TransportManager.getLogcatMsg(perfMetric.getNetworkRequestMetric());
        }
        if (perfMetric.hasGaugeMetric()) {
            return TransportManager.getLogcatMsg(perfMetric.getGaugeMetric());
        }
        return "log";
    }

    private static String getLogcatMsg(TraceMetric traceMetric) {
        long durationInUs = traceMetric.getDurationUs();
        return String.format(Locale.ENGLISH, "trace metric: %s (duration: %.4fms)", traceMetric.getName(), (double)durationInUs / 1000.0);
    }

    private static String getLogcatMsg(NetworkRequestMetric networkRequestMetric) {
        long durationInUs = networkRequestMetric.hasTimeToResponseCompletedUs() ? networkRequestMetric.getTimeToResponseCompletedUs() : 0L;
        String responseCode = networkRequestMetric.hasHttpResponseCode() ? String.valueOf(networkRequestMetric.getHttpResponseCode()) : "UNKNOWN";
        return String.format(Locale.ENGLISH, "network request trace: %s (responseCode: %s, responseTime: %.4fms)", networkRequestMetric.getUrl(), responseCode, (double)durationInUs / 1000.0);
    }

    private static String getLogcatMsg(GaugeMetric gaugeMetric) {
        return String.format(Locale.ENGLISH, "gauges (hasMetadata: %b, cpuGaugeCount: %d, memoryGaugeCount: %d)", gaugeMetric.hasGaugeMetadata(), gaugeMetric.getCpuMetricReadingsCount(), gaugeMetric.getAndroidMemoryReadingsCount());
    }

    @VisibleForTesting
    protected void setInitialized(boolean initialized) {
        this.isTransportInitialized.set(initialized);
    }

    @VisibleForTesting
    protected void clearAppInstanceId() {
        this.applicationInfoBuilder.clearAppInstanceId();
    }

    @VisibleForTesting
    protected ConcurrentLinkedQueue<PendingPerfEvent> getPendingEventsQueue() {
        return new ConcurrentLinkedQueue<PendingPerfEvent>(this.pendingEventsQueue);
    }

    static /* synthetic */ void lambda$log$4(TransportManager this_, GaugeMetric gaugeMetric, ApplicationProcessState appState) {
        this_.syncLog(PerfMetric.newBuilder().setGaugeMetric(gaugeMetric), appState);
    }

    static /* synthetic */ void lambda$log$3(TransportManager this_, NetworkRequestMetric networkRequestMetric, ApplicationProcessState appState) {
        this_.syncLog(PerfMetric.newBuilder().setNetworkRequestMetric(networkRequestMetric), appState);
    }

    static /* synthetic */ void lambda$log$2(TransportManager this_, TraceMetric traceMetric, ApplicationProcessState appState) {
        this_.syncLog(PerfMetric.newBuilder().setTraceMetric(traceMetric), appState);
    }

    static /* synthetic */ void lambda$onUpdateAppState$1(TransportManager this_) {
        this_.rateLimiter.changeRate(this_.isForegroundState);
    }

    static /* synthetic */ void lambda$finishInitialization$0(TransportManager this_, PendingPerfEvent pendingPerfEvent) {
        this_.syncLog(pendingPerfEvent.perfMetricBuilder, pendingPerfEvent.appState);
    }

    static /* synthetic */ void access$lambda$0(TransportManager transportManager) {
        transportManager.syncInit();
    }
}

