/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Bundle;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;

public final class ImmutableBundle {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final Bundle bundle;

    public ImmutableBundle() {
        this(new Bundle());
    }

    public ImmutableBundle(Bundle bundle) {
        this.bundle = (Bundle)bundle.clone();
    }

    public boolean containsKey(String key) {
        return key != null && this.bundle.containsKey(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        if (!this.containsKey(key)) {
            return Optional.empty();
        }
        try {
            Object o = this.bundle.get(key);
            return Optional.ofNullable((Boolean)o);
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Metadata key %s contains type other than boolean: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public Optional<Float> getFloat(String key) {
        if (!this.containsKey(key)) {
            return Optional.empty();
        }
        try {
            Object o = this.bundle.get(key);
            return Optional.ofNullable((Float)o);
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Metadata key %s contains type other than float: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }

    public Optional<Long> getLong(String key) {
        Optional<Integer> intValue = this.getInt(key);
        if (intValue.isPresent()) {
            return Optional.of(Long.valueOf(intValue.get().intValue()));
        }
        return Optional.empty();
    }

    private Optional<Integer> getInt(String key) {
        if (!this.containsKey(key)) {
            return Optional.empty();
        }
        try {
            Object o = this.bundle.get(key);
            return Optional.ofNullable((Integer)o);
        }
        catch (ClassCastException e) {
            logger.debug(String.format("Metadata key %s contains type other than int: %s", key, e.getMessage()), new Object[0]);
            return Optional.empty();
        }
    }
}

