/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.FirebasePerformanceInitializer;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.metrics.AppStartTrace;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;

@Keep
public class FirebasePerfProvider
extends ContentProvider {
    private static final Timer APP_START_TIME = new Clock().getTime();
    @VisibleForTesting
    static final String EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY = "com.google.firebase.firebaseperfprovider";
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public static Timer getAppStartTime() {
        return APP_START_TIME;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        FirebasePerfProvider.checkContentProviderAuthority(info);
        super.attachInfo(context, info);
        ConfigResolver configResolver = ConfigResolver.getInstance();
        configResolver.setContentProviderContext(this.getContext());
        AppStateMonitor appStateMonitor = AppStateMonitor.getInstance();
        appStateMonitor.registerActivityLifecycleCallbacks(this.getContext());
        appStateMonitor.registerForAppColdStart(new FirebasePerformanceInitializer());
        AppStartTrace appStartTrace = AppStartTrace.getInstance();
        appStartTrace.registerActivityLifecycleCallbacks(this.getContext());
        this.mainHandler.post((Runnable)new AppStartTrace.StartFromBackgroundRunnable(appStartTrace));
        SessionManager.getInstance().updatePerfSession(ApplicationProcessState.FOREGROUND);
    }

    public boolean onCreate() {
        return false;
    }

    private static void checkContentProviderAuthority(@NonNull ProviderInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"FirebasePerfProvider ProviderInfo cannot be null.");
        if (EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY.equals(info.authority)) {
            throw new IllegalStateException("Incorrect provider authority in manifest. Most likely due to a missing applicationId variable in application's build.gradle.");
        }
    }

    @Nullable
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

