/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics.validator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.validator.PerfMetricValidator;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.v1.TraceMetric;
import java.util.Map;

final class FirebasePerfTraceValidator
extends PerfMetricValidator {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final TraceMetric traceMetric;

    FirebasePerfTraceValidator(@NonNull TraceMetric traceMetric) {
        this.traceMetric = traceMetric;
    }

    @Override
    public boolean isValidPerfMetric() {
        if (!this.isValidTrace(this.traceMetric, 0)) {
            logger.warn("Invalid Trace:" + this.traceMetric.getName());
            return false;
        }
        if (this.hasCounters(this.traceMetric) && !this.areCountersValid(this.traceMetric)) {
            logger.warn("Invalid Counters for Trace:" + this.traceMetric.getName());
            return false;
        }
        return true;
    }

    private boolean hasCounters(@NonNull TraceMetric trace) {
        boolean hasTraceCounters;
        boolean bl = hasTraceCounters = trace.getCountersCount() > 0;
        if (hasTraceCounters) {
            return true;
        }
        for (TraceMetric subtrace : trace.getSubtracesList()) {
            boolean hasSubtraceCounters = subtrace.getCountersCount() > 0;
            if (!hasSubtraceCounters) continue;
            return true;
        }
        return false;
    }

    private boolean areCountersValid(@NonNull TraceMetric trace) {
        return this.areCountersValid(trace, 0);
    }

    private boolean areCountersValid(@Nullable TraceMetric trace, int deep) {
        if (trace == null) {
            return false;
        }
        if (deep > 1) {
            logger.warn("Exceed MAX_SUBTRACE_DEEP:1");
            return false;
        }
        for (Map.Entry<String, Long> entry : trace.getCountersMap().entrySet()) {
            if (!this.isValidCounterId(entry.getKey())) {
                logger.warn("invalid CounterId:" + entry.getKey());
                return false;
            }
            if (this.isValidCounterValue(entry.getValue())) continue;
            logger.warn("invalid CounterValue:" + entry.getValue());
            return false;
        }
        for (TraceMetric subtrace : trace.getSubtracesList()) {
            if (this.areCountersValid(subtrace, deep + 1)) continue;
            return false;
        }
        return true;
    }

    private boolean isScreenTrace(@NonNull TraceMetric trace) {
        return trace.getName().startsWith("_st_");
    }

    private boolean isValidScreenTrace(@NonNull TraceMetric trace) {
        Long totalFrames = trace.getCountersMap().get(Constants.CounterNames.FRAMES_TOTAL.toString());
        return totalFrames != null && totalFrames.compareTo(0L) > 0;
    }

    private boolean isValidTrace(@Nullable TraceMetric trace, int deep) {
        if (trace == null) {
            logger.warn("TraceMetric is null");
            return false;
        }
        if (deep > 1) {
            logger.warn("Exceed MAX_SUBTRACE_DEEP:1");
            return false;
        }
        if (!this.isValidTraceId(trace.getName())) {
            logger.warn("invalid TraceId:" + trace.getName());
            return false;
        }
        if (!this.isValidTraceDuration(trace)) {
            logger.warn("invalid TraceDuration:" + trace.getDurationUs());
            return false;
        }
        if (!trace.hasClientStartTimeUs()) {
            logger.warn("clientStartTimeUs is null.");
            return false;
        }
        if (this.isScreenTrace(trace) && !this.isValidScreenTrace(trace)) {
            logger.warn("non-positive totalFrames in screen trace " + trace.getName());
            return false;
        }
        for (TraceMetric subtrace : trace.getSubtracesList()) {
            if (this.isValidTrace(subtrace, deep + 1)) continue;
            return false;
        }
        return this.hasValidAttributes(trace.getCustomAttributesMap());
    }

    private boolean isValidTraceId(@Nullable String traceId) {
        if (traceId == null) {
            return false;
        }
        return !(traceId = traceId.trim()).isEmpty() && traceId.length() <= 100;
    }

    private boolean isValidTraceDuration(@Nullable TraceMetric traceMetric) {
        return traceMetric != null && traceMetric.getDurationUs() > 0L;
    }

    private boolean isValidCounterId(@Nullable String counterId) {
        if (counterId == null) {
            return false;
        }
        if ((counterId = counterId.trim()).isEmpty()) {
            logger.warn("counterId is empty");
            return false;
        }
        if (counterId.length() > 100) {
            logger.warn("counterId exceeded max length 100");
            return false;
        }
        return true;
    }

    private boolean hasValidAttributes(Map<String, String> customAttributes) {
        for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
            String err = PerfMetricValidator.validateAttribute(entry);
            if (err == null) continue;
            logger.warn(err);
            return false;
        }
        return true;
    }

    private boolean isValidCounterValue(@Nullable Long counterValue) {
        return counterValue != null;
    }
}

